/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.DimExtractionFn;
import java.nio.ByteBuffer;

public class DefaultDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 0;
    private final String dimension;
    private final String outputName;

    @JsonCreator
    public DefaultDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName) {
        this.dimension = dimension;
        this.outputName = outputName == null ? dimension : outputName;
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public DimExtractionFn getDimExtractionFn() {
        return null;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = this.dimension.getBytes();
        return ByteBuffer.allocate(1 + dimensionBytes.length).put((byte)0).put(dimensionBytes).array();
    }

    public String toString() {
        return "DefaultDimensionSpec{dimension='" + this.dimension + '\'' + ", outputName='" + this.outputName + '\'' + '}';
    }
}

