/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.MinAggregator;
import io.druid.query.aggregation.MinBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class MinAggregatorFactory
implements AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 4;
    private final String fieldName;
    private final String name;

    @JsonCreator
    public MinAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new MinAggregator(this.name, metricFactory.makeFloatColumnSelector(this.fieldName));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new MinBufferAggregator(metricFactory.makeFloatColumnSelector(this.fieldName));
    }

    @Override
    public Comparator getComparator() {
        return MinAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return MinAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new MinAggregatorFactory(this.name, this.name);
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = this.fieldName.getBytes();
        return ByteBuffer.allocate(1 + fieldNameBytes.length).put((byte)4).put(fieldNameBytes).array();
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Object getAggregatorStartValue() {
        return Double.POSITIVE_INFINITY;
    }

    public String toString() {
        return "MinAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

