/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.google.common.collect.Lists;
import io.druid.query.aggregation.Aggregator;
import io.druid.segment.ObjectColumnSelector;
import java.util.List;

public class JavaScriptAggregator
implements Aggregator {
    private final String name;
    private final ObjectColumnSelector[] selectorList;
    private final ScriptAggregator script;
    private volatile double current;

    public JavaScriptAggregator(String name, List<ObjectColumnSelector> selectorList, ScriptAggregator script) {
        this.name = name;
        this.selectorList = Lists.newArrayList(selectorList).toArray(new ObjectColumnSelector[0]);
        this.script = script;
        this.current = script.reset();
    }

    @Override
    public void aggregate() {
        this.current = this.script.aggregate(this.current, this.selectorList);
    }

    @Override
    public void reset() {
        this.current = this.script.reset();
    }

    @Override
    public Object get() {
        return this.current;
    }

    @Override
    public float getFloat() {
        return (float)this.current;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.script.close();
    }

    static interface ScriptAggregator {
        public double aggregate(double var1, ObjectColumnSelector[] var3);

        public double combine(double var1, double var3);

        public double reset();

        public void close();
    }
}

