/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.CountAggregator;
import io.druid.query.aggregation.CountBufferAggregator;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.segment.ColumnSelectorFactory;
import java.util.Comparator;
import java.util.List;

public class CountAggregatorFactory
implements AggregatorFactory {
    private static final byte[] CACHE_KEY = new byte[]{0};
    private final String name;

    @JsonCreator
    public CountAggregatorFactory(@JsonProperty(value="name") String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        this.name = name;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new CountAggregator(this.name);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new CountBufferAggregator();
    }

    @Override
    public Comparator getComparator() {
        return CountAggregator.COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return CountAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new LongSumAggregatorFactory(this.name, this.name);
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return ImmutableList.of();
    }

    @Override
    public byte[] getCacheKey() {
        return CACHE_KEY;
    }

    @Override
    public String getTypeName() {
        return "float";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 8;
    }

    @Override
    public Object getAggregatorStartValue() {
        return 0;
    }

    public String toString() {
        return "CountAggregatorFactory{name='" + this.name + '\'' + '}';
    }
}

