/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.logger.Logger;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.filter.Filter;
import io.druid.segment.Cursor;
import io.druid.segment.StorageAdapter;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class QueryRunnerHelper {
    private static final Logger log = new Logger(QueryRunnerHelper.class);

    public static Aggregator[] makeAggregators(Cursor cursor, List<AggregatorFactory> aggregatorSpecs) {
        Aggregator[] aggregators = new Aggregator[aggregatorSpecs.size()];
        int aggregatorIndex = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            aggregators[aggregatorIndex] = spec.factorize(cursor);
            ++aggregatorIndex;
        }
        return aggregators;
    }

    public static <T> Iterable<Result<T>> makeCursorBasedQuery(final StorageAdapter adapter, List<Interval> queryIntervals, Filter filter, QueryGranularity granularity, Function<Cursor, Result<T>> mapFn) {
        Preconditions.checkArgument((queryIntervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{queryIntervals});
        return FunctionalIterable.create(adapter.makeCursors(filter, queryIntervals.get(0), granularity)).transform((Function)new Function<Cursor, Cursor>(){

            public Cursor apply(@Nullable Cursor input) {
                log.debug("Running over cursor[%s]", new Object[]{adapter.getInterval(), input.getTime()});
                return input;
            }
        }).keep(mapFn);
    }
}

