/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class Queries {
    public static void verifyAggregations(List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        Preconditions.checkNotNull(aggFactories, (Object)"aggregations cannot be null");
        Preconditions.checkArgument((aggFactories.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one AggregatorFactory");
        if (postAggs != null && !postAggs.isEmpty()) {
            HashSet combinedAggNames = Sets.newHashSet((Iterable)Lists.transform(aggFactories, (Function)new Function<AggregatorFactory, String>(){

                public String apply(@Nullable AggregatorFactory input) {
                    return input.getName();
                }
            }));
            for (PostAggregator postAgg : postAggs) {
                Set<String> dependencies = postAgg.getDependentFields();
                Sets.SetView missing = Sets.difference(dependencies, (Set)combinedAggNames);
                Preconditions.checkArgument((boolean)missing.isEmpty(), (String)"Missing fields [%s] for postAggregator [%s]", (Object[])new Object[]{missing, postAgg.getName()});
                combinedAggNames.add(postAgg.getName());
            }
        }
    }
}

