/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.concurrent.ExecutorServiceConfig;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.query.PrioritizedCallable;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PrioritizedExecutorService
extends AbstractExecutorService {
    private static final int DEFAULT_PRIORITY = 0;
    private final ThreadPoolExecutor threadPoolExecutor;

    public static PrioritizedExecutorService create(Lifecycle lifecycle, ExecutorServiceConfig config) {
        final PrioritizedExecutorService service = new PrioritizedExecutorService(new ThreadPoolExecutor(config.getNumThreads(), config.getNumThreads(), 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(config.getFormatString()).build()));
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
            }

            public void stop() {
                service.shutdownNow();
            }
        });
        return service;
    }

    public PrioritizedExecutorService(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public void shutdown() {
        this.threadPoolExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.threadPoolExecutor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.threadPoolExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.threadPoolExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.threadPoolExecutor.awaitTermination(l, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.threadPoolExecutor.execute(runnable);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(final Callable<T> tCallable) {
        PrioritizedCallable theCallable = tCallable;
        if (!(tCallable instanceof PrioritizedCallable)) {
            theCallable = new PrioritizedCallable<T>(0){

                @Override
                public T call() throws Exception {
                    return tCallable.call();
                }
            };
        }
        return new PrioritizedFuture(theCallable);
    }

    private static class PrioritizedFuture<V>
    extends FutureTask<V>
    implements Comparable<PrioritizedFuture> {
        private final PrioritizedCallable<V> callable;

        public PrioritizedFuture(PrioritizedCallable<V> callable) {
            super(callable);
            this.callable = callable;
        }

        public int getPriority() {
            return this.callable.getPriority();
        }

        @Override
        public int compareTo(PrioritizedFuture future) {
            return -Ints.compare((int)this.getPriority(), (int)future.getPriority());
        }
    }
}

