/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import java.io.IOException;

public class MetricsEmittingQueryRunner<T>
implements QueryRunner<T> {
    private final ServiceEmitter emitter;
    private final Function<Query<T>, ServiceMetricEvent.Builder> builderFn;
    private final QueryRunner<T> queryRunner;
    private final long creationTime;

    public MetricsEmittingQueryRunner(ServiceEmitter emitter, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, QueryRunner<T> queryRunner) {
        this(emitter, builderFn, queryRunner, -1L);
    }

    public MetricsEmittingQueryRunner(ServiceEmitter emitter, Function<Query<T>, ServiceMetricEvent.Builder> builderFn, QueryRunner<T> queryRunner, long creationTime) {
        this.emitter = emitter;
        this.builderFn = builderFn;
        this.queryRunner = queryRunner;
        this.creationTime = creationTime;
    }

    public MetricsEmittingQueryRunner<T> withWaitMeasuredFromNow() {
        return new MetricsEmittingQueryRunner<T>(this.emitter, this.builderFn, this.queryRunner, System.currentTimeMillis());
    }

    @Override
    public Sequence<T> run(final Query<T> query) {
        final ServiceMetricEvent.Builder builder = (ServiceMetricEvent.Builder)this.builderFn.apply(query);
        return new Sequence<T>(){

            public <OutType> OutType accumulate(OutType outType, Accumulator<OutType, T> accumulator) {
                Object retVal;
                long startTime = System.currentTimeMillis();
                try {
                    retVal = MetricsEmittingQueryRunner.this.queryRunner.run(query).accumulate(outType, accumulator);
                }
                catch (RuntimeException e) {
                    builder.setUser10("failed");
                    throw e;
                }
                catch (Error e) {
                    builder.setUser10("failed");
                    throw e;
                }
                finally {
                    long timeTaken = System.currentTimeMillis() - startTime;
                    MetricsEmittingQueryRunner.this.emitter.emit(builder.build("query/time", (Number)timeTaken));
                    if (MetricsEmittingQueryRunner.this.creationTime > 0L) {
                        MetricsEmittingQueryRunner.this.emitter.emit(builder.build("query/wait", (Number)(startTime - MetricsEmittingQueryRunner.this.creationTime)));
                    }
                }
                return (OutType)retVal;
            }

            public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                Yielder retVal;
                long startTime = System.currentTimeMillis();
                try {
                    retVal = MetricsEmittingQueryRunner.this.queryRunner.run(query).toYielder(initValue, accumulator);
                }
                catch (RuntimeException e) {
                    builder.setUser10("failed");
                    throw e;
                }
                catch (Error e) {
                    builder.setUser10("failed");
                    throw e;
                }
                return this.makeYielder(startTime, retVal, builder);
            }

            private <OutType> Yielder<OutType> makeYielder(final long startTime, final Yielder<OutType> yielder, final ServiceMetricEvent.Builder builder2) {
                return new Yielder<OutType>(){

                    public OutType get() {
                        return yielder.get();
                    }

                    public Yielder<OutType> next(OutType initValue) {
                        try {
                            return this.makeYielder(startTime, yielder.next(initValue), builder2);
                        }
                        catch (RuntimeException e) {
                            builder2.setUser10("failed");
                            throw e;
                        }
                        catch (Error e) {
                            builder2.setUser10("failed");
                            throw e;
                        }
                    }

                    public boolean isDone() {
                        return yielder.isDone();
                    }

                    public void close() throws IOException {
                        if (!this.isDone() && builder2.getUser10() == null) {
                            builder2.setUser10("short");
                        }
                        long timeTaken = System.currentTimeMillis() - startTime;
                        MetricsEmittingQueryRunner.this.emitter.emit(builder2.build("query/time", (Number)timeTaken));
                        if (MetricsEmittingQueryRunner.this.creationTime > 0L) {
                            MetricsEmittingQueryRunner.this.emitter.emit(builder2.build("query/wait", (Number)(startTime - MetricsEmittingQueryRunner.this.creationTime)));
                        }
                        yielder.close();
                    }
                };
            }
        };
    }
}

