/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.DelegatingExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public class MetricsEmittingExecutorService
extends DelegatingExecutorService {
    private final ExecutorService base;
    private final ServiceEmitter emitter;
    private final ServiceMetricEvent.Builder metricBuilder;

    public MetricsEmittingExecutorService(ExecutorService base, ServiceEmitter emitter, ServiceMetricEvent.Builder metricBuilder) {
        super(base);
        this.base = base;
        this.emitter = emitter;
        this.metricBuilder = metricBuilder;
    }

    @Override
    public void execute(Runnable runnable) {
        this.emitMetrics();
        this.base.execute(runnable);
    }

    private void emitMetrics() {
        if (this.base instanceof ThreadPoolExecutor) {
            this.emitter.emit(this.metricBuilder.build("exec/backlog", (Number)((ThreadPoolExecutor)this.base).getQueue().size()));
        }
    }
}

