/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.granularity.PeriodGranularity;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.joda.time.Interval;
import org.joda.time.Period;

public class IntervalChunkingQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final Period period;

    public IntervalChunkingQueryRunner(QueryRunner<T> baseRunner, Period period) {
        this.baseRunner = baseRunner;
        this.period = period;
    }

    @Override
    public Sequence<T> run(final Query<T> query) {
        return Sequences.concat((Iterable)FunctionalIterable.create(query.getIntervals()).transformCat((Function)new Function<Interval, Iterable<Interval>>(){

            public Iterable<Interval> apply(@Nullable Interval input) {
                return IntervalChunkingQueryRunner.this.splitInterval(input);
            }
        }).transform(new Function<Interval, Sequence<T>>(){

            public Sequence<T> apply(Interval singleInterval) {
                return IntervalChunkingQueryRunner.this.baseRunner.run(query.withQuerySegmentSpec(new MultipleIntervalSegmentSpec(Arrays.asList(singleInterval))));
            }
        }));
    }

    private Iterable<Interval> splitInterval(Interval interval) {
        if (interval.getEndMillis() == interval.getStartMillis()) {
            return Lists.newArrayList((Object[])new Interval[]{interval});
        }
        ArrayList intervals = Lists.newArrayList();
        Iterator<Long> timestamps = new PeriodGranularity(this.period, null, null).iterable(interval.getStartMillis(), interval.getEndMillis()).iterator();
        long start = Math.max(timestamps.next(), interval.getStartMillis());
        while (timestamps.hasNext()) {
            long end = timestamps.next();
            intervals.add(new Interval(start, end));
            start = end;
        }
        if (start < interval.getEndMillis()) {
            intervals.add(new Interval(start, interval.getEndMillis()));
        }
        return intervals;
    }
}

