/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulationFn;
import java.util.Map;
import javax.annotation.Nullable;

public class FinalizeResultsQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final QueryToolChest<T, Query<T>> toolChest;

    public FinalizeResultsQueryRunner(QueryRunner<T> baseRunner, QueryToolChest<T, Query<T>> toolChest) {
        this.baseRunner = baseRunner;
        this.toolChest = toolChest;
    }

    @Override
    public Sequence<T> run(final Query<T> query) {
        boolean isBySegment = Boolean.parseBoolean(query.getContextValue("bySegment"));
        boolean shouldFinalize = Boolean.parseBoolean(query.getContextValue("finalize", "true"));
        if (shouldFinalize) {
            Function finalizerFn = isBySegment ? new Function<T, T>(){
                final Function<T, T> baseFinalizer;
                {
                    this.baseFinalizer = FinalizeResultsQueryRunner.this.toolChest.makeMetricManipulatorFn(query, new MetricManipulationFn(){

                        @Override
                        public Object manipulate(AggregatorFactory factory, Object object) {
                            return factory.finalizeComputation(factory.deserialize(object));
                        }
                    });
                }

                public T apply(@Nullable T input) {
                    Result result = (Result)input;
                    BySegmentResultValueClass resultsClass = (BySegmentResultValueClass)result.getValue();
                    return new Result(result.getTimestamp(), new BySegmentResultValueClass(Lists.transform(resultsClass.getResults(), this.baseFinalizer), resultsClass.getSegmentId(), resultsClass.getInterval()));
                }
            } : this.toolChest.makeMetricManipulatorFn(query, new MetricManipulationFn(){

                @Override
                public Object manipulate(AggregatorFactory factory, Object object) {
                    return factory.finalizeComputation(object);
                }
            });
            return Sequences.map(this.baseRunner.run(query.withOverriddenContext((Map<String, String>)ImmutableMap.of((Object)"finalize", (Object)"false"))), finalizerFn);
        }
        return this.baseRunner.run(query);
    }
}

