/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Lists;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.NoopDimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.InsensitiveContainsSearchQuerySpec;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.search.search.SearchQuerySpec;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.query.timeseries.TimeseriesQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class Druids {
    private Druids() {
        throw new AssertionError();
    }

    public static AndDimFilterBuilder newAndDimFilterBuilder() {
        return new AndDimFilterBuilder();
    }

    public static OrDimFilterBuilder newOrDimFilterBuilder() {
        return new OrDimFilterBuilder();
    }

    public static NotDimFilterBuilder newNotDimFilterBuilder() {
        return new NotDimFilterBuilder();
    }

    public static SelectorDimFilterBuilder newSelectorDimFilterBuilder() {
        return new SelectorDimFilterBuilder();
    }

    public static NoopDimFilterBuilder newNoopDimFilterBuilder() {
        return new NoopDimFilterBuilder();
    }

    public static TimeseriesQueryBuilder newTimeseriesQueryBuilder() {
        return new TimeseriesQueryBuilder();
    }

    public static SearchQueryBuilder newSearchQueryBuilder() {
        return new SearchQueryBuilder();
    }

    public static TimeBoundaryQueryBuilder newTimeBoundaryQueryBuilder() {
        return new TimeBoundaryQueryBuilder();
    }

    public static ResultBuilder newResultBuilder() {
        return new ResultBuilder();
    }

    public static ResultBuilder<SearchResultValue> newSearchResultBuilder() {
        return new ResultBuilder<SearchResultValue>();
    }

    public static ResultBuilder<TimeBoundaryResultValue> newTimeBoundaryResultBuilder() {
        return new ResultBuilder<TimeBoundaryResultValue>();
    }

    public static class ResultBuilder<T> {
        private DateTime timestamp = new DateTime(0L);
        private Object value = null;

        public Result<T> build() {
            return new Result<Object>(this.timestamp, this.value);
        }

        public ResultBuilder copy(ResultBuilder builder) {
            return new ResultBuilder<T>().timestamp(builder.timestamp).value(builder.value);
        }

        public ResultBuilder<T> timestamp(DateTime t) {
            this.timestamp = t;
            return this;
        }

        public ResultBuilder<T> value(Object v) {
            this.value = v;
            return this;
        }
    }

    public static class TimeBoundaryQueryBuilder {
        private String dataSource = "";
        private QuerySegmentSpec querySegmentSpec = null;
        private Map<String, String> context = null;

        public TimeBoundaryQuery build() {
            return new TimeBoundaryQuery(this.dataSource, this.querySegmentSpec, this.context);
        }

        public TimeBoundaryQueryBuilder copy(TimeBoundaryQueryBuilder builder) {
            return new TimeBoundaryQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).context(builder.context);
        }

        public TimeBoundaryQueryBuilder dataSource(String d) {
            this.dataSource = d;
            return this;
        }

        public TimeBoundaryQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public TimeBoundaryQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public TimeBoundaryQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public TimeBoundaryQueryBuilder context(Map<String, String> c) {
            this.context = c;
            return this;
        }
    }

    public static class SearchQueryBuilder {
        private String dataSource = "";
        private DimFilter dimFilter = null;
        private QueryGranularity granularity = QueryGranularity.ALL;
        private int limit = 0;
        private QuerySegmentSpec querySegmentSpec = null;
        private List<String> dimensions = null;
        private SearchQuerySpec querySpec = null;
        private Map<String, String> context = null;

        public SearchQuery build() {
            return new SearchQuery(this.dataSource, this.dimFilter, this.granularity, this.limit, this.querySegmentSpec, this.dimensions, this.querySpec, null, this.context);
        }

        public SearchQueryBuilder copy(SearchQuery query) {
            return new SearchQueryBuilder().dataSource(query.getDataSource()).intervals(query.getQuerySegmentSpec()).filters(query.getDimensionsFilter()).granularity(query.getGranularity()).limit(query.getLimit()).dimensions(query.getDimensions()).query(query.getQuery()).context(query.getContext());
        }

        public SearchQueryBuilder copy(SearchQueryBuilder builder) {
            return new SearchQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).filters(builder.dimFilter).granularity(builder.granularity).limit(builder.limit).dimensions(builder.dimensions).query(builder.querySpec).context(builder.context);
        }

        public SearchQueryBuilder dataSource(String d) {
            this.dataSource = d;
            return this;
        }

        public SearchQueryBuilder filters(String dimensionName, String value) {
            this.dimFilter = new SelectorDimFilter(dimensionName, value);
            return this;
        }

        public SearchQueryBuilder filters(String dimensionName, String value, String ... values) {
            ArrayList fields = Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter(dimensionName, value)});
            for (String val : values) {
                fields.add(new SelectorDimFilter(dimensionName, val));
            }
            this.dimFilter = new OrDimFilter(fields);
            return this;
        }

        public SearchQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public SearchQueryBuilder granularity(String g) {
            this.granularity = QueryGranularity.fromString(g);
            return this;
        }

        public SearchQueryBuilder granularity(QueryGranularity g) {
            this.granularity = g;
            return this;
        }

        public SearchQueryBuilder limit(int l) {
            this.limit = l;
            return this;
        }

        public SearchQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public SearchQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public SearchQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public SearchQueryBuilder dimensions(String d) {
            this.dimensions = Lists.newArrayList((Object[])new String[]{d});
            return this;
        }

        public SearchQueryBuilder dimensions(List<String> d) {
            this.dimensions = d;
            return this;
        }

        public SearchQueryBuilder query(SearchQuerySpec s) {
            this.querySpec = s;
            return this;
        }

        public SearchQueryBuilder query(String q) {
            this.querySpec = new InsensitiveContainsSearchQuerySpec(q);
            return this;
        }

        public SearchQueryBuilder query(Map<String, Object> q) {
            this.querySpec = new InsensitiveContainsSearchQuerySpec((String)q.get("value"));
            return this;
        }

        public SearchQueryBuilder context(Map<String, String> c) {
            this.context = c;
            return this;
        }
    }

    public static class TimeseriesQueryBuilder {
        private String dataSource = "";
        private QuerySegmentSpec querySegmentSpec = null;
        private DimFilter dimFilter = null;
        private QueryGranularity granularity = QueryGranularity.ALL;
        private List<AggregatorFactory> aggregatorSpecs = Lists.newArrayList();
        private List<PostAggregator> postAggregatorSpecs = Lists.newArrayList();
        private Map<String, String> context = null;

        private TimeseriesQueryBuilder() {
        }

        public TimeseriesQuery build() {
            return new TimeseriesQuery(this.dataSource, this.querySegmentSpec, this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.context);
        }

        public TimeseriesQueryBuilder copy(TimeseriesQuery query) {
            return new TimeseriesQueryBuilder().dataSource(query.getDataSource()).intervals(query.getIntervals()).filters(query.getDimensionsFilter()).granularity(query.getGranularity()).aggregators(query.getAggregatorSpecs()).postAggregators(query.getPostAggregatorSpecs()).context(query.getContext());
        }

        public TimeseriesQueryBuilder copy(TimeseriesQueryBuilder builder) {
            return new TimeseriesQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).filters(builder.dimFilter).granularity(builder.granularity).aggregators(builder.aggregatorSpecs).postAggregators(builder.postAggregatorSpecs).context(builder.context);
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public QuerySegmentSpec getQuerySegmentSpec() {
            return this.querySegmentSpec;
        }

        public DimFilter getDimFilter() {
            return this.dimFilter;
        }

        public QueryGranularity getGranularity() {
            return this.granularity;
        }

        public List<AggregatorFactory> getAggregatorSpecs() {
            return this.aggregatorSpecs;
        }

        public List<PostAggregator> getPostAggregatorSpecs() {
            return this.postAggregatorSpecs;
        }

        public Map<String, String> getContext() {
            return this.context;
        }

        public TimeseriesQueryBuilder dataSource(String ds) {
            this.dataSource = ds;
            return this;
        }

        public TimeseriesQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public TimeseriesQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public TimeseriesQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public TimeseriesQueryBuilder filters(String dimensionName, String value) {
            this.dimFilter = new SelectorDimFilter(dimensionName, value);
            return this;
        }

        public TimeseriesQueryBuilder filters(String dimensionName, String value, String ... values) {
            ArrayList fields = Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter(dimensionName, value)});
            for (String val : values) {
                fields.add(new SelectorDimFilter(dimensionName, val));
            }
            this.dimFilter = new OrDimFilter(fields);
            return this;
        }

        public TimeseriesQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public TimeseriesQueryBuilder granularity(String g) {
            this.granularity = QueryGranularity.fromString(g);
            return this;
        }

        public TimeseriesQueryBuilder granularity(QueryGranularity g) {
            this.granularity = g;
            return this;
        }

        public TimeseriesQueryBuilder aggregators(List<AggregatorFactory> a) {
            this.aggregatorSpecs = a;
            return this;
        }

        public TimeseriesQueryBuilder postAggregators(List<PostAggregator> p) {
            this.postAggregatorSpecs = p;
            return this;
        }

        public TimeseriesQueryBuilder context(Map<String, String> c) {
            this.context = c;
            return this;
        }
    }

    public static class NoopDimFilterBuilder {
        public NoopDimFilter build() {
            return new NoopDimFilter();
        }
    }

    public static class SelectorDimFilterBuilder {
        private String dimension = "";
        private String value = "";

        public SelectorDimFilter build() {
            return new SelectorDimFilter(this.dimension, this.value);
        }

        public SelectorDimFilterBuilder copy(SelectorDimFilterBuilder builder) {
            return new SelectorDimFilterBuilder().dimension(builder.dimension).value(builder.value);
        }

        public SelectorDimFilterBuilder dimension(String d) {
            this.dimension = d;
            return this;
        }

        public SelectorDimFilterBuilder value(String v) {
            this.value = v;
            return this;
        }
    }

    public static class NotDimFilterBuilder {
        private DimFilter field = null;

        public NotDimFilter build() {
            return new NotDimFilter(this.field);
        }

        public NotDimFilterBuilder copy(NotDimFilterBuilder builder) {
            return new NotDimFilterBuilder().field(builder.field);
        }

        public NotDimFilterBuilder field(DimFilter f) {
            this.field = f;
            return this;
        }
    }

    public static class OrDimFilterBuilder {
        private List<DimFilter> fields = Lists.newArrayList();

        public OrDimFilter build() {
            return new OrDimFilter(this.fields);
        }

        public OrDimFilterBuilder copy(OrDimFilterBuilder builder) {
            return new OrDimFilterBuilder().fields(builder.fields);
        }

        public OrDimFilterBuilder fields(String dimensionName, String value, String ... values) {
            this.fields = Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter(dimensionName, value)});
            for (String val : values) {
                this.fields.add(new SelectorDimFilter(dimensionName, val));
            }
            return this;
        }

        public OrDimFilterBuilder fields(List<DimFilter> f) {
            this.fields.addAll(f);
            return this;
        }
    }

    public static class AndDimFilterBuilder {
        private List<DimFilter> fields = Lists.newArrayList();

        public AndDimFilter build() {
            return new AndDimFilter(this.fields);
        }

        public AndDimFilterBuilder copy(AndDimFilterBuilder builder) {
            return new AndDimFilterBuilder().fields(builder.fields);
        }

        public AndDimFilterBuilder fields(List<DimFilter> f) {
            this.fields.addAll(f);
            return this;
        }
    }
}

