/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.MergeIterable;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import io.druid.query.PrioritizedCallable;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ChainedExecutionQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(ChainedExecutionQueryRunner.class);
    private final Iterable<QueryRunner<T>> queryables;
    private final ExecutorService exec;
    private final Ordering<T> ordering;

    public ChainedExecutionQueryRunner(ExecutorService exec, Ordering<T> ordering, QueryRunner<T> ... queryables) {
        this(exec, ordering, Arrays.asList(queryables));
    }

    public ChainedExecutionQueryRunner(ExecutorService exec, Ordering<T> ordering, Iterable<QueryRunner<T>> queryables) {
        this.exec = exec;
        this.ordering = ordering;
        this.queryables = Iterables.unmodifiableIterable((Iterable)Iterables.filter(queryables, (Predicate)Predicates.notNull()));
    }

    @Override
    public Sequence<T> run(final Query<T> query) {
        final int priority = Integer.parseInt(query.getContextValue("priority", "0"));
        if (Iterables.isEmpty(this.queryables)) {
            log.warn("No queryables found.", new Object[0]);
            return Sequences.empty();
        }
        return new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            public Iterator<T> make() {
                ArrayList futures = Lists.newArrayList((Iterable)Iterables.transform((Iterable)ChainedExecutionQueryRunner.this.queryables, (Function)new Function<QueryRunner<T>, Future<List<T>>>(){

                    public Future<List<T>> apply(final QueryRunner<T> input) {
                        return ChainedExecutionQueryRunner.this.exec.submit(new PrioritizedCallable<List<T>>(priority){

                            @Override
                            public List<T> call() throws Exception {
                                try {
                                    return Sequences.toList(input.run(query), (List)Lists.newArrayList());
                                }
                                catch (Exception e) {
                                    log.error((Throwable)e, "Exception with one of the sequences!", new Object[0]);
                                    throw Throwables.propagate((Throwable)e);
                                }
                            }
                        });
                    }
                }));
                return new MergeIterable((Comparator)ChainedExecutionQueryRunner.this.ordering.nullsFirst(), Iterables.transform((Iterable)futures, (Function)new Function<Future<List<T>>, Iterable<T>>(){

                    public Iterable<T> apply(Future<List<T>> input) {
                        try {
                            return input.get();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                })).iterator();
            }

            public void cleanup(Iterator<T> tIterator) {
            }
        });
    }
}

