/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Lists;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.Yielders;
import com.metamx.common.guava.YieldingAccumulator;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import java.util.List;
import org.joda.time.DateTime;

public class BySegmentQueryRunner<T>
implements QueryRunner<T> {
    private final String segmentIdentifier;
    private final DateTime timestamp;
    private final QueryRunner<T> base;

    public BySegmentQueryRunner(String segmentIdentifier, DateTime timestamp, QueryRunner<T> base) {
        this.segmentIdentifier = segmentIdentifier;
        this.timestamp = timestamp;
        this.base = base;
    }

    @Override
    public Sequence<T> run(final Query<T> query) {
        if (Boolean.parseBoolean(query.getContextValue("bySegment"))) {
            final Sequence<T> baseSequence = this.base.run(query);
            return new Sequence<T>(){

                public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                    List results = Sequences.toList((Sequence)baseSequence, (List)Lists.newArrayList());
                    return (OutType)accumulator.accumulate(initValue, new Result(BySegmentQueryRunner.this.timestamp, new BySegmentResultValueClass(results, BySegmentQueryRunner.this.segmentIdentifier, query.getIntervals().get(0))));
                }

                public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                    List results = Sequences.toList((Sequence)baseSequence, (List)Lists.newArrayList());
                    Object retVal = accumulator.accumulate(initValue, new Result(BySegmentQueryRunner.this.timestamp, new BySegmentResultValueClass(results, BySegmentQueryRunner.this.segmentIdentifier, query.getIntervals().get(0))));
                    return Yielders.done((Object)retVal, null);
                }
            };
        }
        return this.base.run(query);
    }
}

