/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.metamx.common.guava.Sequence;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;

public abstract class BaseQuery<T>
implements Query<T> {
    private final String dataSource;
    private final Map<String, String> context;
    private final QuerySegmentSpec querySegmentSpec;
    private volatile Duration duration;

    public BaseQuery(String dataSource, QuerySegmentSpec querySegmentSpec, Map<String, String> context) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource can't be null");
        Preconditions.checkNotNull((Object)querySegmentSpec, (Object)"querySegmentSpec can't be null");
        this.dataSource = dataSource.toLowerCase();
        this.context = context;
        this.querySegmentSpec = querySegmentSpec;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="intervals")
    public QuerySegmentSpec getQuerySegmentSpec() {
        return this.querySegmentSpec;
    }

    @Override
    public Sequence<T> run(QuerySegmentWalker walker) {
        return this.run(this.querySegmentSpec.lookup(this, walker));
    }

    @Override
    public Sequence<T> run(QueryRunner<T> runner) {
        return runner.run(this);
    }

    @Override
    public List<Interval> getIntervals() {
        return this.querySegmentSpec.getIntervals();
    }

    @Override
    public Duration getDuration() {
        if (this.duration == null) {
            Duration totalDuration = new Duration(0L);
            for (Interval interval : this.querySegmentSpec.getIntervals()) {
                if (interval == null) continue;
                totalDuration = totalDuration.plus((ReadableDuration)interval.toDuration());
            }
            this.duration = totalDuration;
        }
        return this.duration;
    }

    @JsonProperty
    public Map<String, String> getContext() {
        return this.context;
    }

    @Override
    public String getContextValue(String key) {
        return this.context == null ? null : this.context.get(key);
    }

    @Override
    public String getContextValue(String key, String defaultValue) {
        String retVal = this.getContextValue(key);
        return retVal == null ? defaultValue : retVal;
    }

    protected Map<String, String> computeOverridenContext(Map<String, String> overrides) {
        TreeMap overridden = Maps.newTreeMap();
        Map<String, String> context = this.getContext();
        if (context != null) {
            overridden.putAll(context);
        }
        overridden.putAll(overrides);
        return overridden;
    }
}

