/*
 * Decompiled with CFR 0.152.
 */
package io.druid.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.granularity.BaseQueryGranularity;
import java.nio.ByteBuffer;
import org.joda.time.DateTime;

public class DurationGranularity
extends BaseQueryGranularity {
    private final long length;
    private final long origin;

    @JsonCreator
    public DurationGranularity(@JsonProperty(value="duration") long duration, @JsonProperty(value="origin") DateTime origin) {
        this(duration, origin == null ? 0L : origin.getMillis());
    }

    public DurationGranularity(long millis, long origin) {
        this.length = millis;
        this.origin = origin % this.length;
    }

    @JsonProperty(value="duration")
    public long getDuration() {
        return this.length;
    }

    @JsonProperty(value="origin")
    public DateTime getOrigin() {
        return new DateTime(this.origin);
    }

    public long getOriginMillis() {
        return this.origin;
    }

    @Override
    public long next(long t) {
        return t + this.getDurationMillis();
    }

    @Override
    public long truncate(long t) {
        long duration = this.getDurationMillis();
        return t - t % duration + this.origin;
    }

    @Override
    public byte[] cacheKey() {
        return ByteBuffer.allocate(16).putLong(this.length).putLong(this.origin).array();
    }

    public long getDurationMillis() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationGranularity that = (DurationGranularity)o;
        if (this.length != that.length) {
            return false;
        }
        return this.origin == that.origin;
    }

    public int hashCode() {
        int result = (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.origin ^ this.origin >>> 32);
        return result;
    }

    public String toString() {
        return "DurationGranularity{length=" + this.length + ", origin=" + this.origin + '}';
    }
}

