/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.metamx.common.exception.FormattedException;
import com.metamx.common.logger.Logger;
import io.druid.data.input.ByteBufferInputRowParser;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.MapInputRowParser;
import io.druid.data.input.impl.TimestampSpec;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProtoBufInputRowParser
implements ByteBufferInputRowParser {
    private static final Logger log = new Logger(ProtoBufInputRowParser.class);
    private final MapInputRowParser inputRowCreator;
    private final Descriptors.Descriptor descriptor;

    @JsonCreator
    public ProtoBufInputRowParser(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions, @JsonProperty(value="descriptor") String descriptorFileInClasspath) {
        this.descriptor = this.getDescriptor(descriptorFileInClasspath);
        this.inputRowCreator = new MapInputRowParser(timestampSpec, dimensions, dimensionExclusions);
    }

    public InputRow parse(ByteBuffer input) throws FormattedException {
        Map<String, Object> theMap = this.buildStringKeyMap(input);
        return this.inputRowCreator.parse(theMap);
    }

    private Map<String, Object> buildStringKeyMap(ByteBuffer input) {
        HashMap theMap = Maps.newHashMap();
        try {
            DynamicMessage message = DynamicMessage.parseFrom((Descriptors.Descriptor)this.descriptor, (ByteString)ByteString.copyFrom((ByteBuffer)input));
            Map allFields = message.getAllFields();
            for (Map.Entry entry : allFields.entrySet()) {
                String name = ((Descriptors.FieldDescriptor)entry.getKey()).getName();
                if (theMap.containsKey(name)) continue;
                Object value = entry.getValue();
                if (value instanceof Descriptors.EnumValueDescriptor) {
                    Descriptors.EnumValueDescriptor desc = (Descriptors.EnumValueDescriptor)value;
                    value = desc.getName();
                }
                theMap.put(name, value);
            }
        }
        catch (InvalidProtocolBufferException e) {
            log.warn((Throwable)e, "Problem with protobuf something", new Object[0]);
        }
        return theMap;
    }

    private Descriptors.Descriptor getDescriptor(String descriptorFileInClassPath) {
        try {
            InputStream fin = this.getClass().getClassLoader().getResourceAsStream(descriptorFileInClassPath);
            DescriptorProtos.FileDescriptorSet set = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)fin);
            Descriptors.FileDescriptor file = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)set.getFile(0), (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
            return (Descriptors.Descriptor)file.getMessageTypes().get(0);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void addDimensionExclusion(String dimension) {
        this.inputRowCreator.addDimensionExclusion(dimension);
    }
}

