/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.collect.Maps;
import com.metamx.common.exception.FormattedException;
import com.metamx.common.parsers.Parser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ToLowerCaseParser
implements Parser<String, Object> {
    private final Parser baseParser;

    public ToLowerCaseParser(Parser baseParser) {
        this.baseParser = baseParser;
    }

    @Override
    public Map parse(String input) throws FormattedException {
        Map line = this.baseParser.parse(input);
        LinkedHashMap retVal = Maps.newLinkedHashMap();
        for (Map.Entry entry : line.entrySet()) {
            String k = ((String)entry.getKey()).toLowerCase();
            if (retVal.containsKey(k)) {
                throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_ROW).withMessage(String.format("Duplicate key [%s]", k)).build();
            }
            retVal.put(k, entry.getValue());
        }
        return retVal;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        this.baseParser.setFieldNames(fieldNames);
    }

    @Override
    public List<String> getFieldNames() {
        return this.baseParser.getFieldNames();
    }
}

