/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.metamx.common.collect.Utils;
import com.metamx.common.exception.FormattedException;
import com.metamx.common.parsers.Parser;
import com.metamx.common.parsers.ParserUtils;
import java.util.List;
import java.util.Map;

public class DelimitedParser
implements Parser<String, Object> {
    public static final String DEFAULT_DELIMITER = "\t";
    public static final String DEFAULT_LIST_DELIMITER = "\u0001";
    protected String delimiter;
    protected String listDelimiter;
    protected Splitter splitter;
    protected Splitter listSplitter;
    protected List<String> fieldNames;
    protected Function<String, Object> valueFunction = new Function<String, Object>(){

        public Object apply(String input) {
            if (input.contains(DelimitedParser.this.listDelimiter)) {
                return Lists.newArrayList((Iterable)Iterables.transform((Iterable)DelimitedParser.this.listSplitter.split((CharSequence)input), ParserUtils.nullEmptyStringFunction));
            }
            return ParserUtils.nullEmptyStringFunction.apply((Object)input);
        }
    };

    public DelimitedParser(String delimiter, String listDelimiter) {
        this.init(delimiter, listDelimiter);
    }

    public DelimitedParser(String delimiter) {
        this(delimiter, DEFAULT_LIST_DELIMITER);
    }

    public DelimitedParser() {
        this(DEFAULT_DELIMITER, DEFAULT_LIST_DELIMITER);
    }

    public DelimitedParser(Iterable<String> fieldNames, String delimiter, String listDelimiter) {
        this(delimiter, listDelimiter);
        this.setFieldNames(fieldNames);
    }

    public DelimitedParser(Iterable<String> fieldNames, String delimiter) {
        this(fieldNames, delimiter, DEFAULT_LIST_DELIMITER);
    }

    public DelimitedParser(Iterable<String> fieldNames) {
        this(fieldNames, DEFAULT_DELIMITER, DEFAULT_LIST_DELIMITER);
    }

    protected void init(String delimiter, String listDelimiter) {
        this.delimiter = delimiter;
        this.listDelimiter = listDelimiter;
        this.splitter = Splitter.on((String)delimiter);
        this.listSplitter = Splitter.on((String)listDelimiter);
        this.fieldNames = null;
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        ParserUtils.validateFields(fieldNames);
        this.fieldNames = Lists.newArrayList(fieldNames);
    }

    public void setFieldNames(String header) {
        try {
            this.setFieldNames(this.splitter.split((CharSequence)header));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, FormattedException.class);
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_HEADER).withMessage(e.getMessage()).build();
        }
    }

    @Override
    public Map<String, Object> parse(String input) throws FormattedException {
        try {
            Iterable values = this.splitter.split((CharSequence)input);
            if (this.fieldNames == null) {
                this.setFieldNames(ParserUtils.generateFieldNames(Iterators.size(values.iterator())));
            }
            return Utils.zipMapPartial(this.fieldNames, Iterables.transform((Iterable)values, this.valueFunction));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, FormattedException.class);
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_ROW).withMessage(e.getMessage()).build();
        }
    }
}

