/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.collect.Utils;
import com.metamx.common.exception.FormattedException;
import com.metamx.common.parsers.Parser;
import com.metamx.common.parsers.ParserUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CSVParser
implements Parser<String, Object> {
    protected ArrayList<String> fieldNames = null;
    protected au.com.bytecode.opencsv.CSVParser parser = new au.com.bytecode.opencsv.CSVParser();
    public static final String DEFAULT_LIST_DELIMITER = "\u0001";
    protected static final Splitter listSplitter = Splitter.on((String)"\u0001");
    protected Function<String, Object> valueFunction = new Function<String, Object>(){

        public Object apply(String input) {
            if (input.contains(CSVParser.DEFAULT_LIST_DELIMITER)) {
                return Lists.newArrayList((Iterable)Iterables.transform((Iterable)listSplitter.split((CharSequence)input), ParserUtils.nullEmptyStringFunction));
            }
            return ParserUtils.nullEmptyStringFunction.apply((Object)input);
        }
    };

    public CSVParser() {
    }

    public CSVParser(Iterable<String> fieldNames) {
        this.setFieldNames(fieldNames);
    }

    public CSVParser(String header) throws FormattedException {
        this.setFieldNames(header);
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
        ParserUtils.validateFields(fieldNames);
        this.fieldNames = Lists.newArrayList(fieldNames);
    }

    public void setFieldNames(String header) throws FormattedException {
        try {
            this.setFieldNames(Arrays.asList(this.parser.parseLine(header)));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, FormattedException.class);
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_HEADER).withMessage(e.getMessage()).build();
        }
    }

    @Override
    public Map<String, Object> parse(String input) throws FormattedException {
        try {
            Object[] values = this.parser.parseLine(input);
            if (this.fieldNames == null) {
                this.setFieldNames(ParserUtils.generateFieldNames(values.length));
            }
            return Utils.zipMapPartial(this.fieldNames, Iterables.transform((Iterable)Lists.newArrayList((Object[])values), this.valueFunction));
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, FormattedException.class);
            throw new FormattedException.Builder().withErrorCode(FormattedException.ErrorCode.UNPARSABLE_ROW).withMessage(e.getMessage()).build();
        }
    }
}

