/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.io.smoosh;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.metamx.common.collect.Utils;
import com.metamx.common.io.smoosh.FileSmoosher;
import com.metamx.common.io.smoosh.SmooshedFileMapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class Smoosh {
    public static Map<String, File> smoosh(File inDir, File outDir) throws IOException {
        List<File> files = Arrays.asList(inDir.listFiles());
        return Smoosh.smoosh(inDir, outDir, Utils.zipMap(Iterables.transform(files, (Function)new Function<File, String>(){

            public String apply(@Nullable File input) {
                return input.getName();
            }
        }), files));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, File> smoosh(File inDir, File outDir, Map<String, File> filesToSmoosh) throws IOException {
        FileSmoosher smoosher = new FileSmoosher(outDir);
        try {
            for (Map.Entry<String, File> entry : filesToSmoosh.entrySet()) {
                smoosher.add(entry.getKey(), entry.getValue());
            }
        }
        finally {
            smoosher.close();
        }
        return filesToSmoosh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void smoosh(File outDir, Map<String, ByteBuffer> bufferstoSmoosh) throws IOException {
        FileSmoosher smoosher = new FileSmoosher(outDir);
        try {
            for (Map.Entry<String, ByteBuffer> entry : bufferstoSmoosh.entrySet()) {
                smoosher.add(entry.getKey(), entry.getValue());
            }
        }
        finally {
            smoosher.close();
        }
    }

    public static SmooshedFileMapper map(File inDir) throws IOException {
        return SmooshedFileMapper.load(inDir);
    }
}

