/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import com.google.common.base.Throwables;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ExecutorExecutingSequence<T>
implements Sequence<T> {
    private final Sequence<T> sequence;
    private final ExecutorService exec;

    public ExecutorExecutingSequence(Sequence<T> sequence, ExecutorService exec) {
        this.sequence = sequence;
        this.exec = exec;
    }

    @Override
    public <OutType> OutType accumulate(final OutType initValue, final Accumulator<OutType, T> accumulator) {
        Future future = this.exec.submit(new Callable<OutType>(){

            @Override
            public OutType call() throws Exception {
                return ExecutorExecutingSequence.this.sequence.accumulate(initValue, accumulator);
            }
        });
        try {
            return (OutType)future.get();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(final OutType initValue, final YieldingAccumulator<OutType, T> accumulator) {
        Future future = this.exec.submit(new Callable<Yielder<OutType>>(){

            @Override
            public Yielder<OutType> call() throws Exception {
                return ExecutorExecutingSequence.this.makeYielder(ExecutorExecutingSequence.this.sequence.toYielder(initValue, accumulator));
            }
        });
        try {
            return (Yielder)future.get();
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private <OutType> Yielder<OutType> makeYielder(final Yielder<OutType> yielder) {
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return yielder.get();
            }

            @Override
            public Yielder<OutType> next(final OutType initValue) {
                Future future = ExecutorExecutingSequence.this.exec.submit(new Callable<Yielder<OutType>>(){

                    @Override
                    public Yielder<OutType> call() throws Exception {
                        return ExecutorExecutingSequence.this.makeYielder(yielder.next(initValue));
                    }
                });
                try {
                    return (Yielder)future.get();
                }
                catch (InterruptedException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }

            @Override
            public boolean isDone() {
                return yielder.isDone();
            }

            @Override
            public void close() throws IOException {
                yielder.close();
            }
        };
    }
}

