/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.guava;

import java.util.Comparator;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;

public class Comparators {
    private static final Comparator<Interval> INTERVAL_COMPARATOR = new Comparator<Interval>(){
        private DateTimeComparator dateTimeComp = DateTimeComparator.getInstance();

        @Override
        public int compare(Interval lhs, Interval rhs) {
            int retVal = this.dateTimeComp.compare((Object)lhs.getStart(), (Object)rhs.getStart());
            if (retVal == 0) {
                retVal = this.dateTimeComp.compare((Object)lhs.getEnd(), (Object)rhs.getEnd());
            }
            return retVal;
        }
    };

    public static <T> Comparator<T> inverse(final Comparator<T> baseComp) {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t1) {
                return -baseComp.compare(t, t1);
            }
        };
    }

    @Deprecated
    public static <T extends Comparable> Comparator<T> comparable() {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t1) {
                return t.compareTo(t1);
            }
        };
    }

    @Deprecated
    public static Comparator<Interval> intervals() {
        return Comparators.intervalsByStartThenEnd();
    }

    public static Comparator<Interval> intervalsByStartThenEnd() {
        return INTERVAL_COMPARATOR;
    }
}

