/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.exception;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.Map;

public class FormattedException
extends RuntimeException {
    private final ErrorCode errorCode;
    private final Map<String, Object> details;
    private final String message;

    private FormattedException(ErrorCode errorCode, Map<String, Object> details, String message) {
        this.errorCode = errorCode;
        this.details = details;
        this.message = message;
    }

    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public Map<String, Object> getDetails() {
        return this.details;
    }

    @Override
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    public static class Builder {
        private ErrorCode errorCode;
        private Map<String, Object> details = Maps.newHashMap();
        private String message;

        public Builder fromException(FormattedException e) {
            this.errorCode = e.errorCode;
            this.details = e.details;
            this.message = e.message;
            return this;
        }

        public Builder withErrorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder withDetails(Map<String, Object> details) {
            this.details.clear();
            this.details.putAll(details);
            return this;
        }

        public Builder withAppendedDetails(Map<String, Object> details) {
            this.details.putAll(details);
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public FormattedException build() {
            return new FormattedException(this.errorCode, this.details, this.message);
        }
    }

    public static enum SubErrorCode {
        DUPLICATE_KEY,
        INVALID_CHARACTER,
        MISMATCH;

    }

    public static enum ErrorCode {
        S3BUCKET_NOT_FOUND,
        S3PATH_NOT_FOUND,
        FILE_NOT_FOUND,
        UNPARSABLE_HEADER,
        UNPARSABLE_ROW,
        MISSING_TIMESTAMP,
        UNPARSABLE_TIMESTAMP,
        MISSING_METRIC,
        UNPARSABLE_METRIC,
        SERVER_ERROR,
        AUTHENTICATION_FILE_NOT_FOUND,
        AUTHENTICATION_ERROR,
        IO_ERROR;

    }
}

