/*
 * Decompiled with CFR 0.152.
 */
package io.druid.db;

import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.db.DbConnectorConfig;
import io.druid.db.DbTablesConfig;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class DbConnector {
    private static final Logger log = new Logger(DbConnector.class);
    private final Supplier<DbConnectorConfig> config;
    private final Supplier<DbTablesConfig> dbTables;
    private final DBI dbi;

    public static void createSegmentTable(IDBI dbi, String segmentTableName) {
        DbConnector.createTable(dbi, segmentTableName, String.format("CREATE table %s (id VARCHAR(255) NOT NULL, dataSource VARCHAR(255) NOT NULL, created_date TINYTEXT NOT NULL, start TINYTEXT NOT NULL, end TINYTEXT NOT NULL, partitioned BOOLEAN NOT NULL, version TINYTEXT NOT NULL, used BOOLEAN NOT NULL, payload LONGTEXT NOT NULL, INDEX(dataSource), INDEX(used), PRIMARY KEY (id))", segmentTableName));
    }

    public static void createRuleTable(IDBI dbi, String ruleTableName) {
        DbConnector.createTable(dbi, ruleTableName, String.format("CREATE table %s (id VARCHAR(255) NOT NULL, dataSource VARCHAR(255) NOT NULL, version TINYTEXT NOT NULL, payload LONGTEXT NOT NULL, INDEX(dataSource), PRIMARY KEY (id))", ruleTableName));
    }

    public static void createConfigTable(IDBI dbi, String configTableName) {
        DbConnector.createTable(dbi, configTableName, String.format("CREATE table %s (name VARCHAR(255) NOT NULL, payload BLOB NOT NULL, PRIMARY KEY(name))", configTableName));
    }

    public static void createTaskTable(IDBI dbi, String taskTableName) {
        DbConnector.createTable(dbi, taskTableName, String.format("CREATE TABLE `%s` (\n  `id` varchar(255) NOT NULL,\n  `created_date` tinytext NOT NULL,\n  `datasource` varchar(255) NOT NULL,\n  `payload` longblob NOT NULL,\n  `status_payload` longblob NOT NULL,\n  `active` tinyint(1) NOT NULL DEFAULT '0',\n  PRIMARY KEY (`id`),\n  KEY (active, created_date(100))\n)", taskTableName));
    }

    public static void createTaskLogTable(IDBI dbi, String taskLogsTableName) {
        DbConnector.createTable(dbi, taskLogsTableName, String.format("CREATE TABLE `%s` (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\n  `task_id` varchar(255) DEFAULT NULL,\n  `log_payload` longblob,\n  PRIMARY KEY (`id`),\n  KEY `task_id` (`task_id`)\n)", taskLogsTableName));
    }

    public static void createTaskLockTable(IDBI dbi, String taskLocksTableName) {
        DbConnector.createTable(dbi, taskLocksTableName, String.format("CREATE TABLE `%s` (\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\n  `task_id` varchar(255) DEFAULT NULL,\n  `lock_payload` longblob,\n  PRIMARY KEY (`id`),\n  KEY `task_id` (`task_id`)\n)", taskLocksTableName));
    }

    public static void createTable(IDBI dbi, final String tableName, final String sql) {
        try {
            dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    if (!handle.getConnection().getMetaData().getDatabaseProductName().contains("PostgreSQL")) {
                        List table = handle.select(String.format("SHOW tables LIKE '%s'", tableName), new Object[0]);
                        if (table.isEmpty()) {
                            log.info("Creating table[%s]", new Object[]{tableName});
                            handle.createStatement(sql).execute();
                        } else {
                            log.info("Table[%s] existed: [%s]", new Object[]{tableName, table});
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception creating table", new Object[0]);
        }
    }

    @Inject
    public DbConnector(Supplier<DbConnectorConfig> config, Supplier<DbTablesConfig> dbTables) {
        this.config = config;
        this.dbTables = dbTables;
        this.dbi = new DBI(this.getDatasource());
    }

    public DBI getDBI() {
        return this.dbi;
    }

    private DataSource getDatasource() {
        DbConnectorConfig connectorConfig = (DbConnectorConfig)this.config.get();
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUsername(connectorConfig.getUser());
        dataSource.setPassword(connectorConfig.getPassword());
        dataSource.setUrl(connectorConfig.getConnectURI());
        if (connectorConfig.isUseValidationQuery()) {
            dataSource.setValidationQuery(connectorConfig.getValidationQuery());
            dataSource.setTestOnBorrow(true);
        }
        return dataSource;
    }

    public void createSegmentTable() {
        if (((DbConnectorConfig)this.config.get()).isCreateTables()) {
            DbConnector.createSegmentTable((IDBI)this.dbi, ((DbTablesConfig)this.dbTables.get()).getSegmentsTable());
        }
    }

    public void createRulesTable() {
        if (((DbConnectorConfig)this.config.get()).isCreateTables()) {
            DbConnector.createRuleTable((IDBI)this.dbi, ((DbTablesConfig)this.dbTables.get()).getRulesTable());
        }
    }

    public void createConfigTable() {
        if (((DbConnectorConfig)this.config.get()).isCreateTables()) {
            DbConnector.createConfigTable((IDBI)this.dbi, ((DbTablesConfig)this.dbTables.get()).getConfigTable());
        }
    }

    public void createTaskTables() {
        if (((DbConnectorConfig)this.config.get()).isCreateTables()) {
            DbTablesConfig dbTablesConfig = (DbTablesConfig)this.dbTables.get();
            DbConnector.createTaskTable((IDBI)this.dbi, dbTablesConfig.getTasksTable());
            DbConnector.createTaskLogTable((IDBI)this.dbi, dbTablesConfig.getTaskLogTable());
            DbConnector.createTaskLockTable((IDBI)this.dbi, dbTablesConfig.getTaskLockTable());
        }
    }
}

