/*
 * Decompiled with CFR 0.152.
 */
package io.druid.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Execs {
    public static ExecutorService singleThreaded(String nameFormat) {
        return Executors.newSingleThreadExecutor(Execs.makeThreadFactory(nameFormat));
    }

    public static ExecutorService multiThreaded(int threads, String nameFormat) {
        return Executors.newFixedThreadPool(threads, Execs.makeThreadFactory(nameFormat));
    }

    public static ScheduledExecutorService scheduledSingleThreaded(String nameFormat) {
        return Executors.newSingleThreadScheduledExecutor(Execs.makeThreadFactory(nameFormat));
    }

    public static ThreadFactory makeThreadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat).build();
    }

    public static ExecutorService newBlockingSingleThreaded(String nameFormat, int capacity) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(capacity), Execs.makeThreadFactory(nameFormat), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    ((ArrayBlockingQueue)executor.getQueue()).put(r);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException("Got Interrupted while adding to the Queue");
                }
            }
        });
    }
}

