/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.collections.ResourceHolder;
import java.io.IOException;
import java.util.LinkedList;

public class StupidPool<T> {
    private static final Logger log = new Logger(StupidPool.class);
    private final Supplier<T> generator;
    private final LinkedList<T> objects = Lists.newLinkedList();

    public StupidPool(Supplier<T> generator) {
        this.generator = generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHolder<T> take() {
        LinkedList<T> linkedList = this.objects;
        synchronized (linkedList) {
            if (this.objects.size() > 0) {
                return new ObjectResourceHolder(this.objects.removeFirst());
            }
        }
        return new ObjectResourceHolder(this.generator.get());
    }

    private class ObjectResourceHolder
    implements ResourceHolder<T> {
        private boolean closed = false;
        private final T object;

        public ObjectResourceHolder(T object) {
            this.object = object;
        }

        @Override
        public synchronized T get() {
            if (this.closed) {
                throw new ISE("Already Closed!", new Object[0]);
            }
            return this.object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                log.warn((Throwable)new ISE("Already Closed!", new Object[0]), "Already closed", new Object[0]);
                return;
            }
            LinkedList linkedList = StupidPool.this.objects;
            synchronized (linkedList) {
                this.closed = true;
                StupidPool.this.objects.addLast(this.object);
            }
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                log.warn("Not closed!  Object was[%s]. Allowing gc to prevent leak.", new Object[]{this.object});
            }
        }
    }
}

