/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Ordering;
import com.google.common.io.Closeables;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.Yielders;
import com.metamx.common.guava.YieldingAccumulator;
import com.metamx.common.guava.YieldingAccumulators;
import java.io.IOException;
import java.util.PriorityQueue;
import javax.annotation.Nullable;

public class OrderedMergeSequence<T>
implements Sequence<T> {
    private final Ordering<T> ordering;
    private final Sequence<Sequence<T>> sequences;

    public OrderedMergeSequence(Ordering<T> ordering, Sequence<Sequence<T>> sequences) {
        this.ordering = ordering;
        this.sequences = sequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
        Yielder<OutType> yielder = null;
        try {
            yielder = this.toYielder(initValue, YieldingAccumulators.fromAccumulator(accumulator));
            Object object = yielder.get();
            return (OutType)object;
        }
        finally {
            Closeables.closeQuietly(yielder);
        }
    }

    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        PriorityQueue<Yielder<T>> pQueue = new PriorityQueue<Yielder<T>>(32, this.ordering.onResultOf(new Function<Yielder<T>, T>(){

            public T apply(@Nullable Yielder<T> input) {
                return input.get();
            }
        }));
        Yielder oldDudeAtCrosswalk = this.sequences.toYielder(null, new YieldingAccumulator<Yielder<T>, Sequence<T>>(){

            public Yielder<T> accumulate(Yielder<T> accumulated, Sequence<T> in) {
                Yielder retVal = in.toYielder(null, new YieldingAccumulator<T, T>(){

                    public T accumulate(T accumulated, T in) {
                        this.yield();
                        return in;
                    }
                });
                if (retVal.isDone()) {
                    try {
                        retVal.close();
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    return null;
                }
                this.yield();
                return retVal;
            }
        });
        return this.makeYielder(pQueue, oldDudeAtCrosswalk, initValue, accumulator);
    }

    private <OutType> Yielder<OutType> makeYielder(final PriorityQueue<Yielder<T>> pQueue, Yielder<Yielder<T>> oldDudeAtCrosswalk, OutType initVal, final YieldingAccumulator<OutType, T> accumulator) {
        Object retVal = initVal;
        while (!(accumulator.yielded() || pQueue.isEmpty() && oldDudeAtCrosswalk.isDone())) {
            Yielder yielder;
            if (oldDudeAtCrosswalk.isDone()) {
                yielder = (Yielder)pQueue.remove();
            } else if (pQueue.isEmpty()) {
                yielder = (Yielder)oldDudeAtCrosswalk.get();
                oldDudeAtCrosswalk = oldDudeAtCrosswalk.next(null);
            } else {
                Yielder<T> queueYielder = pQueue.peek();
                Yielder iterYielder = (Yielder)oldDudeAtCrosswalk.get();
                if (this.ordering.compare(queueYielder.get(), iterYielder.get()) <= 0) {
                    yielder = (Yielder)pQueue.remove();
                } else {
                    yielder = (Yielder)oldDudeAtCrosswalk.get();
                    oldDudeAtCrosswalk = oldDudeAtCrosswalk.next(null);
                }
            }
            retVal = accumulator.accumulate(retVal, yielder.get());
            yielder = yielder.next(null);
            if (yielder.isDone()) {
                try {
                    yielder.close();
                    continue;
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            pQueue.add(yielder);
        }
        if (!accumulator.yielded()) {
            return Yielders.done(retVal, oldDudeAtCrosswalk);
        }
        final OutType yieldVal = retVal;
        final Yielder finalOldDudeAtCrosswalk = oldDudeAtCrosswalk;
        return new Yielder<OutType>(){

            public OutType get() {
                return yieldVal;
            }

            public Yielder<OutType> next(OutType initValue) {
                accumulator.reset();
                return OrderedMergeSequence.this.makeYielder(pQueue, finalOldDudeAtCrosswalk, initValue, accumulator);
            }

            public boolean isDone() {
                return false;
            }

            public void close() throws IOException {
                while (!pQueue.isEmpty()) {
                    ((Yielder)pQueue.remove()).close();
                }
            }
        };
    }
}

