/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.AbstractConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ConstrainedParameter
extends AbstractConstrainedElement {
    private final String name;

    public ConstrainedParameter(ConfigurationSource source, ExecutableConstraintLocation location, String name, Set<MetaConstraint<?>> constraints, Map<Class<?>, Class<?>> groupConversions, boolean isCascading) {
        super(source, ConstrainedElement.ConstrainedElementKind.PARAMETER, location, constraints, groupConversions, isCascading);
        this.name = name;
    }

    @Override
    public ExecutableConstraintLocation getLocation() {
        return (ExecutableConstraintLocation)super.getLocation();
    }

    public String getParameterName() {
        return this.name;
    }

    public ConstrainedParameter merge(ConstrainedParameter other) {
        ConfigurationSource mergedSource = ConfigurationSource.max(this.source, other.source);
        String mergedName = this.source.getPriority() > other.source.getPriority() ? this.name : other.name;
        HashSet<MetaConstraint<?>> mergedConstraints = CollectionHelper.newHashSet(this.constraints);
        mergedConstraints.addAll(other.constraints);
        HashMap<Class<?>, Class<?>> mergedGroupConversions = CollectionHelper.newHashMap(this.groupConversions);
        mergedGroupConversions.putAll(other.groupConversions);
        return new ConstrainedParameter(mergedSource, this.getLocation(), mergedName, mergedConstraints, mergedGroupConversions, this.isCascading || other.isCascading);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MetaConstraint<?> oneConstraint : this.getConstraints()) {
            sb.append(oneConstraint.getDescriptor().getAnnotation().annotationType().getSimpleName());
            sb.append(", ");
        }
        String constraintsAsString = sb.length() > 0 ? sb.substring(0, sb.length() - 2) : sb.toString();
        return "ParameterMetaData [location=" + this.getLocation() + "], name=" + this.name + "], constraints=[" + constraintsAsString + "], isCascading=" + this.isCascading() + "]";
    }
}

