/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.path;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import com.metamx.common.Granularity;
import com.metamx.common.guava.Comparators;
import com.metamx.common.logger.Logger;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.hadoop.FSSpideringIterator;
import io.druid.indexer.path.PathSpec;
import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class GranularityPathSpec
implements PathSpec {
    private static final Logger log = new Logger(GranularityPathSpec.class);
    private String inputPath;
    private String filePattern;
    private Granularity dataGranularity;
    private String pathFormat;

    @JsonProperty
    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    @JsonProperty
    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    @JsonProperty
    public Granularity getDataGranularity() {
        return this.dataGranularity;
    }

    public void setDataGranularity(Granularity dataGranularity) {
        this.dataGranularity = dataGranularity;
    }

    @JsonProperty
    public String getPathFormat() {
        return this.pathFormat;
    }

    public void setPathFormat(String pathFormat) {
        this.pathFormat = pathFormat;
    }

    @Override
    public Job addInputPaths(HadoopDruidIndexerConfig config, Job job) throws IOException {
        TreeSet intervals = Sets.newTreeSet((Comparator)Comparators.intervals());
        for (Interval segmentInterval : config.getSegmentGranularIntervals()) {
            for (Interval dataInterval : this.dataGranularity.getIterable(segmentInterval)) {
                intervals.add(dataInterval);
            }
        }
        Path betaInput = new Path(this.inputPath);
        FileSystem fs = betaInput.getFileSystem(job.getConfiguration());
        TreeSet paths = Sets.newTreeSet();
        Pattern fileMatcher = Pattern.compile(this.filePattern);
        DateTimeFormatter customFormatter = null;
        if (this.pathFormat != null) {
            customFormatter = DateTimeFormat.forPattern((String)this.pathFormat);
        }
        for (Interval interval : intervals) {
            DateTime t = interval.getStart();
            String intervalPath = null;
            intervalPath = customFormatter != null ? customFormatter.print((ReadableInstant)t) : this.dataGranularity.toPath(t);
            Path granularPath = new Path(betaInput, intervalPath);
            log.info("Checking path[%s]", new Object[]{granularPath});
            for (FileStatus status : FSSpideringIterator.spiderIterable(fs, granularPath)) {
                Path filePath = status.getPath();
                if (!fileMatcher.matcher(filePath.toString()).matches()) continue;
                paths.add(filePath.toString());
            }
        }
        for (String path : paths) {
            log.info("Appending path[%s]", new Object[]{path});
            FileInputFormat.addInputPath((Job)job, (Path)new Path(path));
        }
        return job;
    }
}

