/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;

public class PartitionsSpec {
    private static final double DEFAULT_OVERSIZE_THRESHOLD = 1.5;
    @Nullable
    private final String partitionDimension;
    private final long targetPartitionSize;
    private final long maxPartitionSize;
    private final boolean assumeGrouped;

    @JsonCreator
    public PartitionsSpec(@JsonProperty(value="partitionDimension") @Nullable String partitionDimension, @JsonProperty(value="targetPartitionSize") @Nullable Long targetPartitionSize, @JsonProperty(value="maxPartitionSize") @Nullable Long maxPartitionSize, @JsonProperty(value="assumeGrouped") @Nullable Boolean assumeGrouped) {
        this.partitionDimension = partitionDimension;
        this.targetPartitionSize = targetPartitionSize == null ? -1L : targetPartitionSize;
        this.maxPartitionSize = maxPartitionSize == null ? (long)((double)this.targetPartitionSize * 1.5) : maxPartitionSize;
        this.assumeGrouped = assumeGrouped == null ? false : assumeGrouped;
    }

    @JsonIgnore
    public boolean isDeterminingPartitions() {
        return this.targetPartitionSize > 0L;
    }

    @JsonProperty
    @Nullable
    public String getPartitionDimension() {
        return this.partitionDimension;
    }

    @JsonProperty
    public long getTargetPartitionSize() {
        return this.targetPartitionSize;
    }

    @JsonProperty
    public long getMaxPartitionSize() {
        return this.maxPartitionSize;
    }

    @JsonProperty
    public boolean isAssumeGrouped() {
        return this.assumeGrouped;
    }
}

