/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.hadoop;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FSSpideringIterator
implements Iterator<FileStatus> {
    private final FileSystem fs;
    private final FileStatus[] statii;
    FSSpideringIterator statuses = null;
    int index = 0;

    public static FSSpideringIterator spiderPathPropogateExceptions(FileSystem fs, Path path) {
        try {
            FileStatus[] statii = fs.listStatus(path);
            return new FSSpideringIterator(fs, statii == null ? new FileStatus[]{} : statii);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Iterable<FileStatus> spiderIterable(final FileSystem fs, final Path path) {
        return new Iterable<FileStatus>(){

            @Override
            public Iterator<FileStatus> iterator() {
                return FSSpideringIterator.spiderPathPropogateExceptions(fs, path);
            }
        };
    }

    public FSSpideringIterator(FileSystem fs, FileStatus[] statii) {
        this.fs = fs;
        this.statii = statii;
    }

    @Override
    public boolean hasNext() {
        if (this.statuses != null && !this.statuses.hasNext()) {
            this.statuses = null;
            ++this.index;
        }
        return this.index < this.statii.length;
    }

    @Override
    public FileStatus next() {
        while (this.hasNext()) {
            if (this.statii[this.index].isDir()) {
                if (this.statuses == null) {
                    this.statuses = FSSpideringIterator.spiderPathPropogateExceptions(this.fs, this.statii[this.index].getPath());
                    continue;
                }
                if (!this.statuses.hasNext()) continue;
                return this.statuses.next();
            }
            ++this.index;
            return this.statii[this.index - 1];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

