/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.Granularity;
import io.druid.indexer.granularity.ArbitraryGranularitySpec;
import io.druid.indexer.granularity.GranularitySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class UniformGranularitySpec
implements GranularitySpec {
    private final Granularity granularity;
    private final List<Interval> inputIntervals;
    private final ArbitraryGranularitySpec wrappedSpec;

    @JsonCreator
    public UniformGranularitySpec(@JsonProperty(value="gran") Granularity granularity, @JsonProperty(value="intervals") List<Interval> inputIntervals) {
        ArrayList granularIntervals = Lists.newArrayList();
        for (Interval inputInterval : inputIntervals) {
            Iterables.addAll((Collection)granularIntervals, (Iterable)granularity.getIterable(inputInterval));
        }
        this.granularity = granularity;
        this.inputIntervals = ImmutableList.copyOf(inputIntervals);
        this.wrappedSpec = new ArbitraryGranularitySpec(granularIntervals);
    }

    @Override
    public SortedSet<Interval> bucketIntervals() {
        return this.wrappedSpec.bucketIntervals();
    }

    @Override
    public Optional<Interval> bucketInterval(DateTime dt) {
        return this.wrappedSpec.bucketInterval(dt);
    }

    @Override
    @JsonProperty(value="gran")
    public Granularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty(value="intervals")
    public Iterable<Interval> getIntervals() {
        return this.inputIntervals;
    }
}

