/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer.granularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.metamx.common.Granularity;
import com.metamx.common.guava.Comparators;
import io.druid.indexer.granularity.GranularitySpec;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class ArbitraryGranularitySpec
implements GranularitySpec {
    private final TreeSet<Interval> intervals = Sets.newTreeSet((Comparator)Comparators.intervalsByStartThenEnd());

    @JsonCreator
    public ArbitraryGranularitySpec(@JsonProperty(value="intervals") List<Interval> inputIntervals) {
        for (Interval inputInterval : inputIntervals) {
            this.intervals.add(inputInterval);
        }
        PeekingIterator intervalIterator = Iterators.peekingIterator(this.intervals.iterator());
        while (intervalIterator.hasNext()) {
            Interval nextInterval;
            Interval currentInterval = (Interval)intervalIterator.next();
            if (!intervalIterator.hasNext() || !currentInterval.overlaps((ReadableInterval)(nextInterval = (Interval)intervalIterator.peek()))) continue;
            throw new IllegalArgumentException(String.format("Overlapping intervals: %s, %s", currentInterval, nextInterval));
        }
    }

    @Override
    @JsonProperty(value="intervals")
    public SortedSet<Interval> bucketIntervals() {
        return this.intervals;
    }

    @Override
    public Optional<Interval> bucketInterval(DateTime dt) {
        Interval interval = this.intervals.floor(new Interval((ReadableInstant)dt, (ReadableInstant)new DateTime(Long.MAX_VALUE)));
        if (interval != null && interval.contains((ReadableInstant)dt)) {
            return Optional.of((Object)interval);
        }
        return Optional.absent();
    }

    @Override
    public Granularity getGranularity() {
        throw new UnsupportedOperationException();
    }
}

