/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.api.client.util.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.metamx.common.logger.Logger;
import io.druid.indexer.HadoopDruidIndexerConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;

public class JobHelper {
    private static final Logger log = new Logger(JobHelper.class);
    private static final Set<Path> existing = Sets.newHashSet();

    public static void setupClasspath(HadoopDruidIndexerConfig config, Job groupByJob) throws IOException {
        String classpathProperty = System.getProperty("druid.hadoop.internal.classpath");
        if (classpathProperty == null) {
            classpathProperty = System.getProperty("java.class.path");
        }
        String[] jarFiles = classpathProperty.split(File.pathSeparator);
        Configuration conf = groupByJob.getConfiguration();
        final FileSystem fs = FileSystem.get((Configuration)conf);
        Path distributedClassPath = new Path(config.getWorkingPath(), "classpath");
        if (fs instanceof LocalFileSystem) {
            return;
        }
        for (String jarFilePath : jarFiles) {
            File jarFile = new File(jarFilePath);
            if (!jarFile.getName().endsWith(".jar")) continue;
            final Path hdfsPath = new Path(distributedClassPath, jarFile.getName());
            if (!existing.contains(hdfsPath)) {
                if (jarFile.getName().endsWith("SNAPSHOT.jar") || !fs.exists(hdfsPath)) {
                    log.info("Uploading jar to path[%s]", new Object[]{hdfsPath});
                    ByteStreams.copy((InputSupplier)Files.newInputStreamSupplier((File)jarFile), (OutputSupplier)new OutputSupplier<OutputStream>(){

                        public OutputStream getOutput() throws IOException {
                            return fs.create(hdfsPath);
                        }
                    });
                }
                existing.add(hdfsPath);
            }
            DistributedCache.addFileToClassPath((Path)hdfsPath, (Configuration)conf, (FileSystem)fs);
        }
    }
}

