/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.impl.DataSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.granularity.GranularitySpec;
import io.druid.indexer.partitions.PartitionsSpec;
import io.druid.indexer.rollup.DataRollupSpec;
import io.druid.indexer.updater.DbUpdaterJobSpec;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class HadoopDruidIndexerSchema {
    private final String dataSource;
    private final TimestampSpec timestampSpec;
    private final DataSpec dataSpec;
    private final GranularitySpec granularitySpec;
    private final Map<String, Object> pathSpec;
    private final String workingPath;
    private final String segmentOutputPath;
    private final String version;
    private final PartitionsSpec partitionsSpec;
    private final boolean leaveIntermediate;
    private final boolean cleanupOnFailure;
    private final Map<DateTime, List<HadoopyShardSpec>> shardSpecs;
    private final boolean overwriteFiles;
    private final DataRollupSpec rollupSpec;
    private final DbUpdaterJobSpec updaterJobSpec;
    private final boolean ignoreInvalidRows;

    @JsonCreator
    public HadoopDruidIndexerSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dataSpec") DataSpec dataSpec, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="pathSpec") Map<String, Object> pathSpec, @JsonProperty(value="workingPath") String workingPath, @JsonProperty(value="segmentOutputPath") String segmentOutputPath, @JsonProperty(value="version") String version, @JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="leaveIntermediate") boolean leaveIntermediate, @JsonProperty(value="cleanupOnFailure") Boolean cleanupOnFailure, @JsonProperty(value="shardSpecs") Map<DateTime, List<HadoopyShardSpec>> shardSpecs, @JsonProperty(value="overwriteFiles") boolean overwriteFiles, @JsonProperty(value="rollupSpec") DataRollupSpec rollupSpec, @JsonProperty(value="updaterJobSpec") DbUpdaterJobSpec updaterJobSpec, @JsonProperty(value="ignoreInvalidRows") boolean ignoreInvalidRows, @JsonProperty(value="timestampColumn") String timestampColumn, @JsonProperty(value="timestampFormat") String timestampFormat) {
        this.dataSource = dataSource;
        this.timestampSpec = timestampSpec == null ? new TimestampSpec(timestampColumn, timestampFormat) : timestampSpec;
        this.dataSpec = dataSpec;
        this.granularitySpec = granularitySpec;
        this.pathSpec = pathSpec;
        this.workingPath = workingPath;
        this.segmentOutputPath = segmentOutputPath;
        this.version = version == null ? new DateTime().toString() : version;
        this.partitionsSpec = partitionsSpec;
        this.leaveIntermediate = leaveIntermediate;
        this.cleanupOnFailure = cleanupOnFailure == null ? true : cleanupOnFailure;
        this.shardSpecs = shardSpecs == null ? ImmutableMap.of() : shardSpecs;
        this.overwriteFiles = overwriteFiles;
        this.rollupSpec = rollupSpec;
        this.updaterJobSpec = updaterJobSpec;
        this.ignoreInvalidRows = ignoreInvalidRows;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    @JsonProperty
    public DataSpec getDataSpec() {
        return this.dataSpec;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    public Map<String, Object> getPathSpec() {
        return this.pathSpec;
    }

    @JsonProperty
    public String getWorkingPath() {
        return this.workingPath;
    }

    @JsonProperty
    public String getSegmentOutputPath() {
        return this.segmentOutputPath;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public PartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public boolean isLeaveIntermediate() {
        return this.leaveIntermediate;
    }

    @JsonProperty
    public boolean isCleanupOnFailure() {
        return this.cleanupOnFailure;
    }

    @JsonProperty
    public Map<DateTime, List<HadoopyShardSpec>> getShardSpecs() {
        return this.shardSpecs;
    }

    @JsonProperty
    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }

    @JsonProperty
    public DataRollupSpec getRollupSpec() {
        return this.rollupSpec;
    }

    @JsonProperty
    public DbUpdaterJobSpec getUpdaterJobSpec() {
        return this.updaterJobSpec;
    }

    @JsonProperty
    public boolean isIgnoreInvalidRows() {
        return this.ignoreInvalidRows;
    }
}

