/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.metamx.common.RE;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerConfigBuilder;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.joda.time.DateTime;

public abstract class HadoopDruidIndexerMapper<KEYOUT, VALUEOUT>
extends Mapper<LongWritable, Text, KEYOUT, VALUEOUT> {
    private HadoopDruidIndexerConfig config;
    private StringInputRowParser parser;

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.config = HadoopDruidIndexerConfigBuilder.fromConfiguration(context.getConfiguration());
        this.parser = this.config.getParser();
    }

    public HadoopDruidIndexerConfig getConfig() {
        return this.config;
    }

    public StringInputRowParser getParser() {
        return this.parser;
    }

    protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            InputRow inputRow;
            try {
                inputRow = this.parser.parse(value.toString());
            }
            catch (Exception e) {
                if (this.config.isIgnoreInvalidRows()) {
                    context.getCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.INVALID_ROW_COUNTER).increment(1L);
                    return;
                }
                throw e;
            }
            if (this.config.getGranularitySpec().bucketInterval(new DateTime(inputRow.getTimestampFromEpoch())).isPresent()) {
                this.innerMap(inputRow, value, context);
            }
        }
        catch (RuntimeException e) {
            throw new RE((Throwable)e, "Failure on row[%s]", new Object[]{value});
        }
    }

    protected abstract void innerMap(InputRow var1, Text var2, Mapper.Context var3) throws IOException, InterruptedException;
}

