/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.indexer.DbUpdaterJob;
import io.druid.indexer.DeterminePartitionsJob;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.IndexGeneratorJob;
import io.druid.indexer.Jobby;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;

public class HadoopDruidIndexerJob
implements Jobby {
    private static final Logger log = new Logger(HadoopDruidIndexerJob.class);
    private final HadoopDruidIndexerConfig config;
    private final DbUpdaterJob dbUpdaterJob;
    private IndexGeneratorJob indexJob;
    private volatile List<DataSegment> publishedSegments = null;

    @Inject
    public HadoopDruidIndexerJob(HadoopDruidIndexerConfig config) {
        config.verify();
        this.config = config;
        this.dbUpdaterJob = config.isUpdaterJobSpecSet() ? new DbUpdaterJob(config) : null;
    }

    @Override
    public boolean run() {
        ArrayList jobs = Lists.newArrayList();
        this.ensurePaths();
        if (this.config.partitionByDimension()) {
            jobs.add(new DeterminePartitionsJob(this.config));
        } else {
            TreeMap shardSpecs = Maps.newTreeMap((Comparator)DateTimeComparator.getInstance());
            int shardCount = 0;
            for (Interval segmentGranularity : this.config.getSegmentGranularIntervals()) {
                DateTime bucket = segmentGranularity.getStart();
                HadoopyShardSpec spec = new HadoopyShardSpec((ShardSpec)new NoneShardSpec(), shardCount++);
                shardSpecs.put(bucket, Lists.newArrayList((Object[])new HadoopyShardSpec[]{spec}));
                log.info("DateTime[%s], spec[%s]", new Object[]{bucket, spec});
            }
            this.config.setShardSpecs(shardSpecs);
        }
        this.indexJob = new IndexGeneratorJob(this.config);
        jobs.add(this.indexJob);
        if (this.dbUpdaterJob != null) {
            jobs.add(this.dbUpdaterJob);
        } else {
            log.info("No updaterJobSpec set, not uploading to database", new Object[0]);
        }
        String failedMessage = null;
        for (Jobby job : jobs) {
            if (failedMessage != null || job.run()) continue;
            failedMessage = String.format("Job[%s] failed!", job.getClass());
        }
        if (failedMessage == null) {
            this.publishedSegments = IndexGeneratorJob.getPublishedSegments(this.config);
        }
        if (!this.config.isLeaveIntermediate() && (failedMessage == null || this.config.isCleanupOnFailure())) {
            Path workingPath = this.config.makeIntermediatePath();
            log.info("Deleting path[%s]", new Object[]{workingPath});
            try {
                workingPath.getFileSystem(new Configuration()).delete(workingPath, true);
            }
            catch (IOException e) {
                log.error((Throwable)e, "Failed to cleanup path[%s]", new Object[]{workingPath});
            }
        }
        if (failedMessage != null) {
            throw new ISE(failedMessage, new Object[0]);
        }
        return true;
    }

    private void ensurePaths() {
        try {
            Job job = new Job(new Configuration(), String.format("%s-determine_partitions-%s", this.config.getDataSource(), this.config.getIntervals()));
            job.getConfiguration().set("io.sort.record.percent", "0.19");
            for (String propName : System.getProperties().stringPropertyNames()) {
                Configuration conf = job.getConfiguration();
                if (!propName.startsWith("hadoop.")) continue;
                conf.set(propName.substring("hadoop.".length()), System.getProperty(propName));
            }
            this.config.addInputPaths(job);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<DataSegment> getPublishedSegments() {
        if (this.publishedSegments == null) {
            throw new IllegalStateException("Job hasn't run yet. No segments have been published yet.");
        }
        return this.publishedSegments;
    }

    public IndexGeneratorJob.IndexGeneratorStats getIndexJobStats() {
        return this.indexJob.getJobStats();
    }
}

