/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.druid.data.input.impl.DataSpec;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerSchema;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.granularity.GranularitySpec;
import io.druid.indexer.partitions.PartitionsSpec;
import io.druid.indexer.path.PathSpec;
import io.druid.indexer.rollup.DataRollupSpec;
import io.druid.indexer.updater.DbUpdaterJobSpec;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.joda.time.DateTime;

public class HadoopDruidIndexerConfigBuilder {
    private volatile String dataSource = null;
    private volatile TimestampSpec timestampSpec = null;
    private volatile DataSpec dataSpec = null;
    private volatile GranularitySpec granularitySpec = null;
    private volatile PathSpec pathSpec = null;
    private volatile String workingPath = null;
    private volatile String segmentOutputPath = null;
    private volatile String version = new DateTime().toString();
    private volatile PartitionsSpec partitionsSpec = null;
    private volatile boolean leaveIntermediate = false;
    private volatile boolean cleanupOnFailure = true;
    private volatile Map<DateTime, List<HadoopyShardSpec>> shardSpecs = ImmutableMap.of();
    private volatile boolean overwriteFiles = false;
    private volatile DataRollupSpec rollupSpec = null;
    private volatile DbUpdaterJobSpec updaterJobSpec = null;
    private volatile boolean ignoreInvalidRows = false;

    public static HadoopDruidIndexerConfig fromSchema(HadoopDruidIndexerSchema schema) {
        return (HadoopDruidIndexerConfig)HadoopDruidIndexerConfig.jsonMapper.convertValue((Object)schema, HadoopDruidIndexerConfig.class);
    }

    public static HadoopDruidIndexerConfig fromMap(Map<String, Object> argSpec) {
        return (HadoopDruidIndexerConfig)HadoopDruidIndexerConfig.jsonMapper.convertValue(argSpec, HadoopDruidIndexerConfig.class);
    }

    public static HadoopDruidIndexerConfig fromFile(File file) {
        try {
            return HadoopDruidIndexerConfigBuilder.fromMap((Map)HadoopDruidIndexerConfig.jsonMapper.readValue(file, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static HadoopDruidIndexerConfig fromString(String str) {
        try {
            return HadoopDruidIndexerConfigBuilder.fromMap((Map)HadoopDruidIndexerConfig.jsonMapper.readValue(str, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static HadoopDruidIndexerConfig fromConfiguration(Configuration conf) {
        HadoopDruidIndexerConfig retVal = HadoopDruidIndexerConfigBuilder.fromString(conf.get("druid.indexer.config"));
        retVal.verify();
        return retVal;
    }

    public HadoopDruidIndexerConfigBuilder withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withTimestampSpec(TimestampSpec timestampSpec) {
        this.timestampSpec = timestampSpec;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withDataSpec(DataSpec dataSpec) {
        this.dataSpec = dataSpec;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withGranularitySpec(GranularitySpec granularitySpec) {
        this.granularitySpec = granularitySpec;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withPathSpec(PathSpec pathSpec) {
        this.pathSpec = pathSpec;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withWorkingPath(String workingPath) {
        this.workingPath = workingPath;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withSegmentOutputPath(String segmentOutputPath) {
        this.segmentOutputPath = segmentOutputPath;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withPartitionsSpec(PartitionsSpec partitionsSpec) {
        this.partitionsSpec = partitionsSpec;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withLeaveIntermediate(boolean leaveIntermediate) {
        this.leaveIntermediate = leaveIntermediate;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withCleanupOnFailure(boolean cleanupOnFailure) {
        this.cleanupOnFailure = cleanupOnFailure;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withShardSpecs(Map<DateTime, List<HadoopyShardSpec>> shardSpecs) {
        this.shardSpecs = shardSpecs;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withOverwriteFiles(boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withRollupSpec(DataRollupSpec rollupSpec) {
        this.rollupSpec = rollupSpec;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withUpdaterJobSpec(DbUpdaterJobSpec updaterJobSpec) {
        this.updaterJobSpec = updaterJobSpec;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withIgnoreInvalidRows(boolean ignoreInvalidRows) {
        this.ignoreInvalidRows = ignoreInvalidRows;
        return this;
    }

    public HadoopDruidIndexerConfigBuilder withSchema(HadoopDruidIndexerSchema schema) {
        this.dataSource = schema.getDataSource();
        this.timestampSpec = schema.getTimestampSpec();
        this.dataSpec = schema.getDataSpec();
        this.granularitySpec = schema.getGranularitySpec();
        this.pathSpec = (PathSpec)HadoopDruidIndexerConfig.jsonMapper.convertValue(schema.getPathSpec(), PathSpec.class);
        this.workingPath = schema.getWorkingPath();
        this.segmentOutputPath = schema.getSegmentOutputPath();
        this.version = schema.getVersion();
        this.partitionsSpec = schema.getPartitionsSpec();
        this.leaveIntermediate = schema.isLeaveIntermediate();
        this.cleanupOnFailure = schema.isCleanupOnFailure();
        this.shardSpecs = schema.getShardSpecs();
        this.overwriteFiles = schema.isOverwriteFiles();
        this.rollupSpec = schema.getRollupSpec();
        this.updaterJobSpec = schema.getUpdaterJobSpec();
        this.ignoreInvalidRows = schema.isIgnoreInvalidRows();
        return this;
    }

    public HadoopDruidIndexerConfig build() {
        return new HadoopDruidIndexerConfig(this.dataSource, this.timestampSpec, this.dataSpec, this.granularitySpec, this.pathSpec, this.workingPath, this.segmentOutputPath, this.version, this.partitionsSpec, this.leaveIntermediate, this.cleanupOnFailure, this.shardSpecs, this.overwriteFiles, this.rollupSpec, this.updaterJobSpec, this.ignoreInvalidRows, null, null, null, null, null, null);
    }
}

