/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.metamx.common.Granularity;
import com.metamx.common.ISE;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.logger.Logger;
import io.druid.common.utils.JodaUtils;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.DataSpec;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.data.input.impl.ToLowercaseDataSpec;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.annotations.Self;
import io.druid.indexer.Bucket;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.granularity.GranularitySpec;
import io.druid.indexer.granularity.UniformGranularitySpec;
import io.druid.indexer.partitions.PartitionsSpec;
import io.druid.indexer.path.PathSpec;
import io.druid.indexer.rollup.DataRollupSpec;
import io.druid.indexer.updater.DbUpdaterJobSpec;
import io.druid.initialization.Initialization;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.server.DruidNode;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.ShardSpec;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class HadoopDruidIndexerConfig {
    private static final Logger log = new Logger(HadoopDruidIndexerConfig.class);
    private static final Injector injector;
    public static final String CONFIG_PROPERTY = "druid.indexer.config";
    public static final Charset javaNativeCharset;
    public static final Splitter tabSplitter;
    public static final Joiner tabJoiner;
    public static final ObjectMapper jsonMapper;
    private volatile String dataSource;
    private volatile TimestampSpec timestampSpec;
    private volatile DataSpec dataSpec;
    private volatile GranularitySpec granularitySpec;
    private volatile PathSpec pathSpec;
    private volatile String workingPath;
    private volatile String segmentOutputPath;
    private volatile String version;
    private volatile PartitionsSpec partitionsSpec;
    private volatile boolean leaveIntermediate;
    private volatile boolean cleanupOnFailure;
    private volatile Map<DateTime, List<HadoopyShardSpec>> shardSpecs;
    private volatile boolean overwriteFiles;
    private volatile DataRollupSpec rollupSpec;
    private volatile DbUpdaterJobSpec updaterJobSpec;
    private volatile boolean ignoreInvalidRows;

    @JsonCreator
    public HadoopDruidIndexerConfig(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dataSpec") DataSpec dataSpec, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="pathSpec") PathSpec pathSpec, @JsonProperty(value="workingPath") String workingPath, @JsonProperty(value="segmentOutputPath") String segmentOutputPath, @JsonProperty(value="version") String version, @JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="leaveIntermediate") boolean leaveIntermediate, @JsonProperty(value="cleanupOnFailure") Boolean cleanupOnFailure, @JsonProperty(value="shardSpecs") Map<DateTime, List<HadoopyShardSpec>> shardSpecs, @JsonProperty(value="overwriteFiles") boolean overwriteFiles, @JsonProperty(value="rollupSpec") DataRollupSpec rollupSpec, @JsonProperty(value="updaterJobSpec") DbUpdaterJobSpec updaterJobSpec, @JsonProperty(value="ignoreInvalidRows") boolean ignoreInvalidRows, @JsonProperty(value="timestampColumn") String timestampColumn, @JsonProperty(value="timestampFormat") String timestampFormat, @JsonProperty(value="intervals") List<Interval> intervals, @JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="partitionDimension") String partitionDimension, @JsonProperty(value="targetPartitionSize") Long targetPartitionSize) {
        this.dataSource = dataSource;
        this.timestampSpec = timestampSpec == null ? new TimestampSpec(timestampColumn, timestampFormat) : timestampSpec;
        this.dataSpec = dataSpec;
        this.pathSpec = pathSpec;
        this.workingPath = workingPath;
        this.segmentOutputPath = segmentOutputPath;
        this.version = version == null ? new DateTime().toString() : version;
        this.leaveIntermediate = leaveIntermediate;
        this.cleanupOnFailure = cleanupOnFailure == null ? true : cleanupOnFailure;
        this.shardSpecs = shardSpecs == null ? ImmutableMap.of() : shardSpecs;
        this.overwriteFiles = overwriteFiles;
        this.rollupSpec = rollupSpec;
        this.updaterJobSpec = updaterJobSpec;
        this.ignoreInvalidRows = ignoreInvalidRows;
        if (partitionsSpec != null) {
            Preconditions.checkArgument((partitionDimension == null && targetPartitionSize == null ? 1 : 0) != 0, (Object)"Cannot mix partitionsSpec with partitionDimension/targetPartitionSize");
            this.partitionsSpec = partitionsSpec;
        } else {
            this.partitionsSpec = new PartitionsSpec(partitionDimension, targetPartitionSize, null, false);
        }
        if (granularitySpec != null) {
            Preconditions.checkArgument((segmentGranularity == null && intervals == null ? 1 : 0) != 0, (Object)"Cannot mix granularitySpec with segmentGranularity/intervals");
            this.granularitySpec = granularitySpec;
        } else if (segmentGranularity != null && intervals != null) {
            this.granularitySpec = new UniformGranularitySpec(segmentGranularity, intervals);
        }
    }

    public HadoopDruidIndexerConfig() {
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource.toLowerCase();
    }

    @JsonProperty
    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    public void setTimestampSpec(TimestampSpec timestampSpec) {
        this.timestampSpec = timestampSpec;
    }

    @JsonProperty
    public DataSpec getDataSpec() {
        return this.dataSpec;
    }

    public void setDataSpec(DataSpec dataSpec) {
        this.dataSpec = new ToLowercaseDataSpec(dataSpec);
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    public void setGranularitySpec(GranularitySpec granularitySpec) {
        this.granularitySpec = granularitySpec;
    }

    @JsonProperty
    public PathSpec getPathSpec() {
        return this.pathSpec;
    }

    public void setPathSpec(PathSpec pathSpec) {
        this.pathSpec = pathSpec;
    }

    @JsonProperty
    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    @JsonProperty
    public String getSegmentOutputPath() {
        return this.segmentOutputPath;
    }

    public void setSegmentOutputPath(String segmentOutputPath) {
        this.segmentOutputPath = segmentOutputPath;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty
    public PartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    public void setPartitionsSpec(PartitionsSpec partitionsSpec) {
        this.partitionsSpec = partitionsSpec;
    }

    @JsonProperty
    public boolean isLeaveIntermediate() {
        return this.leaveIntermediate;
    }

    public void setLeaveIntermediate(boolean leaveIntermediate) {
        this.leaveIntermediate = leaveIntermediate;
    }

    @JsonProperty
    public boolean isCleanupOnFailure() {
        return this.cleanupOnFailure;
    }

    public void setCleanupOnFailure(boolean cleanupOnFailure) {
        this.cleanupOnFailure = cleanupOnFailure;
    }

    @JsonProperty
    public Map<DateTime, List<HadoopyShardSpec>> getShardSpecs() {
        return this.shardSpecs;
    }

    public void setShardSpecs(Map<DateTime, List<HadoopyShardSpec>> shardSpecs) {
        this.shardSpecs = Collections.unmodifiableMap(shardSpecs);
    }

    @JsonProperty
    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }

    public void setOverwriteFiles(boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
    }

    @JsonProperty
    public DataRollupSpec getRollupSpec() {
        return this.rollupSpec;
    }

    public void setRollupSpec(DataRollupSpec rollupSpec) {
        this.rollupSpec = rollupSpec;
    }

    @JsonProperty
    public DbUpdaterJobSpec getUpdaterJobSpec() {
        return this.updaterJobSpec;
    }

    public void setUpdaterJobSpec(DbUpdaterJobSpec updaterJobSpec) {
        this.updaterJobSpec = updaterJobSpec;
    }

    @JsonProperty
    public boolean isIgnoreInvalidRows() {
        return this.ignoreInvalidRows;
    }

    public void setIgnoreInvalidRows(boolean ignoreInvalidRows) {
        this.ignoreInvalidRows = ignoreInvalidRows;
    }

    public List<Interval> getIntervals() {
        return JodaUtils.condenseIntervals(this.getGranularitySpec().bucketIntervals());
    }

    public String getPartitionDimension() {
        return this.partitionsSpec.getPartitionDimension();
    }

    public boolean partitionByDimension() {
        return this.partitionsSpec.isDeterminingPartitions();
    }

    public Long getTargetPartitionSize() {
        return this.partitionsSpec.getTargetPartitionSize();
    }

    public long getMaxPartitionSize() {
        return this.partitionsSpec.getMaxPartitionSize();
    }

    public boolean isUpdaterJobSpecSet() {
        return this.updaterJobSpec != null;
    }

    public StringInputRowParser getParser() {
        ArrayList dimensionExclusions;
        if (this.getDataSpec().hasCustomDimensions()) {
            dimensionExclusions = null;
        } else {
            dimensionExclusions = Lists.newArrayList();
            dimensionExclusions.add(this.timestampSpec.getTimestampColumn());
            dimensionExclusions.addAll(Lists.transform(this.getRollupSpec().getAggs(), (Function)new Function<AggregatorFactory, String>(){

                public String apply(AggregatorFactory aggregatorFactory) {
                    return aggregatorFactory.getName();
                }
            }));
        }
        return new StringInputRowParser(this.getTimestampSpec(), this.getDataSpec(), (List)dimensionExclusions);
    }

    public HadoopyShardSpec getShardSpec(Bucket bucket) {
        return this.shardSpecs.get(bucket.time).get(bucket.partitionNum);
    }

    public Job addInputPaths(Job job) throws IOException {
        return this.getPathSpec().addInputPaths(this, job);
    }

    public Optional<Bucket> getBucket(InputRow inputRow) {
        Optional<Interval> timeBucket = this.getGranularitySpec().bucketInterval(new DateTime(inputRow.getTimestampFromEpoch()));
        if (!timeBucket.isPresent()) {
            return Optional.absent();
        }
        List<HadoopyShardSpec> shards = this.shardSpecs.get(((Interval)timeBucket.get()).getStart());
        if (shards == null || shards.isEmpty()) {
            return Optional.absent();
        }
        for (HadoopyShardSpec hadoopyShardSpec : shards) {
            ShardSpec actualSpec = hadoopyShardSpec.getActualSpec();
            if (!actualSpec.isInChunk(inputRow)) continue;
            return Optional.of((Object)new Bucket(hadoopyShardSpec.getShardNum(), ((Interval)timeBucket.get()).getStart(), actualSpec.getPartitionNum()));
        }
        throw new ISE("row[%s] doesn't fit in any shard[%s]", new Object[]{inputRow, shards});
    }

    public Set<Interval> getSegmentGranularIntervals() {
        return this.granularitySpec.bucketIntervals();
    }

    public Iterable<Bucket> getAllBuckets() {
        return FunctionalIterable.create(this.getSegmentGranularIntervals()).transformCat((Function)new Function<Interval, Iterable<Bucket>>(){

            public Iterable<Bucket> apply(Interval input) {
                final DateTime bucketTime = input.getStart();
                List specs = (List)HadoopDruidIndexerConfig.this.shardSpecs.get(bucketTime);
                if (specs == null) {
                    return ImmutableList.of();
                }
                return FunctionalIterable.create((Iterable)specs).transform((Function)new Function<HadoopyShardSpec, Bucket>(){
                    int i = 0;

                    public Bucket apply(HadoopyShardSpec input) {
                        return new Bucket(input.getShardNum(), bucketTime, this.i++);
                    }
                });
            }
        });
    }

    public Path makeIntermediatePath() {
        return new Path(String.format("%s/%s/%s", this.getWorkingPath(), this.getDataSource(), this.getVersion().replace(":", "")));
    }

    public Path makeSegmentPartitionInfoPath(Bucket bucket) {
        Interval bucketInterval = (Interval)this.getGranularitySpec().bucketInterval(bucket.time).get();
        return new Path(String.format("%s/%s_%s/partitions.json", this.makeIntermediatePath(), ISODateTimeFormat.basicDateTime().print((ReadableInstant)bucketInterval.getStart()), ISODateTimeFormat.basicDateTime().print((ReadableInstant)bucketInterval.getEnd())));
    }

    public Path makeDescriptorInfoDir() {
        return new Path(this.makeIntermediatePath(), "segmentDescriptorInfo");
    }

    public Path makeGroupedDataDir() {
        return new Path(this.makeIntermediatePath(), "groupedData");
    }

    public Path makeDescriptorInfoPath(DataSegment segment) {
        return new Path(this.makeDescriptorInfoDir(), String.format("%s.json", segment.getIdentifier().replace(":", "")));
    }

    public Path makeSegmentOutputPath(FileSystem fileSystem, Bucket bucket) {
        Interval bucketInterval = (Interval)this.getGranularitySpec().bucketInterval(bucket.time).get();
        if (fileSystem instanceof DistributedFileSystem) {
            return new Path(String.format("%s/%s/%s_%s/%s/%s", this.getSegmentOutputPath(), this.getDataSource(), bucketInterval.getStart().toString(ISODateTimeFormat.basicDateTime()), bucketInterval.getEnd().toString(ISODateTimeFormat.basicDateTime()), this.getVersion().replace(":", "_"), bucket.partitionNum));
        }
        return new Path(String.format("%s/%s/%s_%s/%s/%s", this.getSegmentOutputPath(), this.getDataSource(), bucketInterval.getStart().toString(), bucketInterval.getEnd().toString(), this.getVersion(), bucket.partitionNum));
    }

    public void intoConfiguration(Job job) {
        Configuration conf = job.getConfiguration();
        try {
            conf.set(CONFIG_PROPERTY, jsonMapper.writeValueAsString((Object)this));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void verify() {
        try {
            log.info("Running with config:%n%s", new Object[]{jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this)});
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkNotNull((Object)this.dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)this.dataSpec, (Object)"dataSpec");
        Preconditions.checkNotNull((Object)this.timestampSpec, (Object)"timestampSpec");
        Preconditions.checkNotNull((Object)this.granularitySpec, (Object)"granularitySpec");
        Preconditions.checkNotNull((Object)this.pathSpec, (Object)"pathSpec");
        Preconditions.checkNotNull((Object)this.workingPath, (Object)"workingPath");
        Preconditions.checkNotNull((Object)this.segmentOutputPath, (Object)"segmentOutputPath");
        Preconditions.checkNotNull((Object)this.version, (Object)"version");
        Preconditions.checkNotNull((Object)this.rollupSpec, (Object)"rollupSpec");
        int nIntervals = this.getIntervals().size();
        Preconditions.checkArgument((nIntervals > 0 ? 1 : 0) != 0, (String)"intervals.size()[%s] <= 0", (Object[])new Object[]{nIntervals});
    }

    static {
        javaNativeCharset = Charset.forName("Unicode");
        tabSplitter = Splitter.on((String)"\t");
        tabJoiner = Joiner.on((String)"\t");
        injector = Initialization.makeInjectorWithModules((Injector)Initialization.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("hadoop-indexer", "localhost", Integer.valueOf(-1)));
            }
        }));
        jsonMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    public static enum IndexJobCounters {
        INVALID_ROW_COUNTER;

    }
}

