/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.logger.Logger;
import io.druid.db.DbConnector;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.IndexGeneratorJob;
import io.druid.indexer.Jobby;
import io.druid.timeline.DataSegment;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class DbUpdaterJob
implements Jobby {
    private static final Logger log = new Logger(DbUpdaterJob.class);
    private final HadoopDruidIndexerConfig config;
    private final IDBI dbi;

    public DbUpdaterJob(HadoopDruidIndexerConfig config) {
        this.config = config;
        this.dbi = new DbConnector((Supplier)config.getUpdaterJobSpec(), null).getDBI();
    }

    @Override
    public boolean run() {
        final List<DataSegment> segments = IndexGeneratorJob.getPublishedSegments(this.config);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                PreparedBatch batch = handle.prepareBatch(String.format("INSERT INTO %s (id, dataSource, created_date, start, end, partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", DbUpdaterJob.this.config.getUpdaterJobSpec().getSegmentTable()));
                for (DataSegment segment : segments) {
                    batch.add((Map)new ImmutableMap.Builder().put((Object)"id", (Object)segment.getIdentifier()).put((Object)"dataSource", (Object)segment.getDataSource()).put((Object)"created_date", (Object)new DateTime().toString()).put((Object)"start", (Object)segment.getInterval().getStart().toString()).put((Object)"end", (Object)segment.getInterval().getEnd().toString()).put((Object)"partitioned", (Object)segment.getShardSpec().getPartitionNum()).put((Object)"version", (Object)segment.getVersion()).put((Object)"used", (Object)true).put((Object)"payload", (Object)HadoopDruidIndexerConfig.jsonMapper.writeValueAsString((Object)segment)).build());
                    log.info("Published %s", new Object[]{segment.getIdentifier()});
                }
                batch.execute();
                return null;
            }
        });
        return true;
    }
}

