/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.tweak.transactions;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.exceptions.TransactionException;
import org.skife.jdbi.v2.tweak.TransactionHandler;

public class LocalTransactionHandler
implements TransactionHandler {
    private final ConcurrentHashMap<Handle, LocalStuff> localStuff = new ConcurrentHashMap();

    @Override
    public void begin(Handle handle) {
        try {
            if (!this.localStuff.containsKey(handle)) {
                boolean initial = handle.getConnection().getAutoCommit();
                this.localStuff.put(handle, new LocalStuff(initial));
                handle.getConnection().setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to start transaction", e);
        }
    }

    @Override
    public void commit(Handle handle) {
        try {
            handle.getConnection().commit();
            LocalStuff stuff = this.localStuff.remove(handle);
            if (stuff != null) {
                handle.getConnection().setAutoCommit(stuff.getInitialAutocommit());
                stuff.getCheckpoints().clear();
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to commit transaction", e);
        }
        finally {
            if (this.localStuff.containsKey(handle)) {
                this.localStuff.remove(handle);
            }
        }
    }

    @Override
    public void rollback(Handle handle) {
        try {
            handle.getConnection().rollback();
            LocalStuff stuff = this.localStuff.remove(handle);
            if (stuff != null) {
                handle.getConnection().setAutoCommit(stuff.getInitialAutocommit());
                stuff.getCheckpoints().clear();
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to rollback transaction", e);
        }
        finally {
            if (this.localStuff.containsKey(handle)) {
                this.localStuff.remove(handle);
            }
        }
    }

    @Override
    public void checkpoint(Handle handle, String name) {
        Connection conn = handle.getConnection();
        try {
            Savepoint savepoint = conn.setSavepoint(name);
            this.localStuff.get(handle).getCheckpoints().put(name, savepoint);
        }
        catch (SQLException e) {
            throw new TransactionException(String.format("Unable to create checkpoint %s", name), e);
        }
    }

    @Override
    public void release(Handle handle, String name) {
        Connection conn = handle.getConnection();
        try {
            Savepoint savepoint = this.localStuff.get(handle).getCheckpoints().remove(name);
            if (savepoint == null) {
                throw new TransactionException(String.format("Attempt to rollback to non-existant savepoint, '%s'", name));
            }
            conn.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new TransactionException(String.format("Unable to create checkpoint %s", name), e);
        }
    }

    @Override
    public void rollback(Handle handle, String name) {
        Connection conn = handle.getConnection();
        try {
            Savepoint savepoint = this.localStuff.get(handle).getCheckpoints().remove(name);
            if (savepoint == null) {
                throw new TransactionException(String.format("Attempt to rollback to non-existant savepoint, '%s'", name));
            }
            conn.rollback(savepoint);
        }
        catch (SQLException e) {
            throw new TransactionException(String.format("Unable to create checkpoint %s", name), e);
        }
    }

    @Override
    public boolean isInTransaction(Handle handle) {
        try {
            return !handle.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            throw new TransactionException("Failed to test for transaction status", e);
        }
    }

    private static class LocalStuff {
        private final Map<String, Savepoint> checkpoints = new HashMap<String, Savepoint>();
        private final boolean initialAutocommit;

        public LocalStuff(boolean initial) {
            this.initialAutocommit = initial;
        }

        public Map<String, Savepoint> getCheckpoints() {
            return this.checkpoints;
        }

        public boolean getInitialAutocommit() {
            return this.initialAutocommit;
        }
    }
}

