/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class OutParameters {
    private final Map<Object, Object> map = new HashMap<Object, Object>();

    public <T> T getObject(String name, Class<T> type) {
        return type.cast(this.getObject(name));
    }

    public Object getObject(String name) {
        return this.map.get(name);
    }

    public Object getObject(int position) {
        return this.map.get(position);
    }

    public <T> T getObject(int pos, Class<T> type) {
        return type.cast(this.getObject(pos));
    }

    public String getString(String name) {
        Object obj = this.map.get(name);
        if (obj != null) {
            return obj.toString();
        }
        throw new IllegalArgumentException(String.format("Parameter %s does not exist", name));
    }

    public String getString(int pos) {
        Object obj = this.map.get(pos);
        if (obj != null) {
            return obj.toString();
        }
        throw new IllegalArgumentException(String.format("Parameter at %d does not exist", pos));
    }

    public byte[] getBytes(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Parameter %s does not exist", name));
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IllegalArgumentException(String.format("Parameter %s is not byte[] but %s", name, obj.getClass()));
    }

    public byte[] getBytes(int pos) {
        Object obj = this.map.get(pos);
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Parameter at %d does not exist", pos));
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IllegalArgumentException(String.format("Parameter at %d is not byte[] but %s", pos, obj.getClass()));
    }

    public Integer getInt(String name) {
        return this.getNumber(name).intValue();
    }

    public Integer getInt(int pos) {
        return this.getNumber(pos).intValue();
    }

    public Long getLong(String name) {
        return this.getNumber(name).longValue();
    }

    public Long getLong(int pos) {
        return this.getNumber(pos).longValue();
    }

    public Short getShort(String name) {
        return this.getNumber(name).shortValue();
    }

    public Short getShort(int pos) {
        return this.getNumber(pos).shortValue();
    }

    public java.sql.Date getDate(String name) {
        return new java.sql.Date(this.getEpoch(name));
    }

    public java.sql.Date getDate(int pos) {
        return new java.sql.Date(this.getEpoch(pos));
    }

    public Timestamp getTimestamp(String name) {
        return new Timestamp(this.getEpoch(name));
    }

    public Timestamp getTimestamp(int pos) {
        return new Timestamp(this.getEpoch(pos));
    }

    public Double getDouble(String name) {
        return this.getNumber(name).doubleValue();
    }

    public Double getDouble(int pos) {
        return this.getNumber(pos).doubleValue();
    }

    public Float getFloat(String name) {
        return Float.valueOf(this.getNumber(name).floatValue());
    }

    public Float getFloat(int pos) {
        return Float.valueOf(this.getNumber(pos).floatValue());
    }

    private Number getNumber(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Parameter %s does not exist", name));
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        throw new IllegalArgumentException(String.format("Parameter %s is not a number but %s", name, obj.getClass()));
    }

    private Number getNumber(int pos) {
        Object obj = this.map.get(pos);
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Parameter at %d does not exist", pos));
        }
        if (obj instanceof Number) {
            return (Number)obj;
        }
        throw new IllegalArgumentException(String.format("Parameter at %d is not a number but %s", pos, obj.getClass()));
    }

    private Long getEpoch(String name) {
        Object obj = this.map.get(name);
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Parameter %s does not exist", name));
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        throw new IllegalArgumentException(String.format("Parameter %s is not Date but %s", name, obj.getClass()));
    }

    private Long getEpoch(int pos) {
        Object obj = this.map.get(pos);
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Parameter at %d does not exist", pos));
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        throw new IllegalArgumentException(String.format("Parameter at %d is not Date but %s", pos, obj.getClass()));
    }

    Map<Object, Object> getMap() {
        return this.map;
    }
}

