/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.skife.jdbi.v2.BigDecimalArgument;
import org.skife.jdbi.v2.BlobArgument;
import org.skife.jdbi.v2.BooleanArgument;
import org.skife.jdbi.v2.ByteArgument;
import org.skife.jdbi.v2.ByteArrayArgument;
import org.skife.jdbi.v2.CharacterArgument;
import org.skife.jdbi.v2.ClobArgument;
import org.skife.jdbi.v2.DoubleArgument;
import org.skife.jdbi.v2.FloatArgument;
import org.skife.jdbi.v2.IntegerArgument;
import org.skife.jdbi.v2.JavaDateArgument;
import org.skife.jdbi.v2.LongArgument;
import org.skife.jdbi.v2.ObjectArgument;
import org.skife.jdbi.v2.ShortArgument;
import org.skife.jdbi.v2.SqlDateArgument;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.StringArgument;
import org.skife.jdbi.v2.TimeArgument;
import org.skife.jdbi.v2.TimestampArgument;
import org.skife.jdbi.v2.URLArgument;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

class Foreman {
    private final List<ArgumentFactory> factories = new CopyOnWriteArrayList<ArgumentFactory>();
    private static final ArgumentFactory BUILT_INS = new BuiltInArgumentFactory();

    public Foreman() {
        this.factories.add(BUILT_INS);
    }

    public Foreman(List<ArgumentFactory> factories) {
        this.factories.addAll(factories);
    }

    Argument waffle(Class expectedType, Object it, StatementContext ctx) {
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            ArgumentFactory factory = this.factories.get(i);
            if (!factory.accepts(expectedType, it, ctx)) continue;
            return factory.build(expectedType, it, ctx);
        }
        throw new IllegalStateException("Unbindable argument passed: " + String.valueOf(it));
    }

    public void register(ArgumentFactory<?> argumentFactory) {
        this.factories.add(argumentFactory);
    }

    public Foreman createChild() {
        return new Foreman(this.factories);
    }

    private static final class BuiltInArgumentFactory
    implements ArgumentFactory {
        private static final Map<Class, P> b = new IdentityHashMap<Class, P>();

        private BuiltInArgumentFactory() {
        }

        public boolean accepts(Class expectedType, Object value, StatementContext ctx) {
            return b.containsKey(expectedType);
        }

        public Argument build(Class expectedType, Object value, StatementContext ctx) {
            return b.get(expectedType).build(value);
        }

        static {
            b.put(BigDecimal.class, new P(BigDecimalArgument.class));
            b.put(Blob.class, new P(BlobArgument.class));
            b.put(Boolean.class, new P(BooleanArgument.class));
            b.put(Boolean.TYPE, new P(BooleanArgument.class));
            b.put(Byte.class, new P(ByteArgument.class));
            b.put(Byte.TYPE, new P(ByteArgument.class));
            b.put(byte[].class, new P(ByteArrayArgument.class));
            b.put(Character.class, new P(CharacterArgument.class));
            b.put(Character.TYPE, new P(CharacterArgument.class));
            b.put(Clob.class, new P(ClobArgument.class));
            b.put(Double.class, new P(DoubleArgument.class));
            b.put(Double.TYPE, new P(DoubleArgument.class));
            b.put(Float.class, new P(FloatArgument.class));
            b.put(Float.TYPE, new P(FloatArgument.class));
            b.put(Integer.class, new P(IntegerArgument.class));
            b.put(Integer.TYPE, new P(IntegerArgument.class));
            b.put(java.util.Date.class, new P(JavaDateArgument.class));
            b.put(Long.class, new P(LongArgument.class));
            b.put(Long.TYPE, new P(LongArgument.class));
            b.put(Object.class, new P(ObjectArgument.class));
            b.put(Short.class, new P(ShortArgument.class));
            b.put(Short.TYPE, new P(ShortArgument.class));
            b.put(Date.class, new P(SqlDateArgument.class));
            b.put(String.class, new P(StringArgument.class));
            b.put(Time.class, new P(TimeArgument.class));
            b.put(Timestamp.class, new P(TimestampArgument.class));
            b.put(URL.class, new P(URLArgument.class));
        }

        private static class P {
            private final Constructor<?> ctor;

            public P(Class<? extends Argument> argType) {
                this.ctor = argType.getDeclaredConstructors()[0];
            }

            public Argument build(Object value) {
                try {
                    return (Argument)this.ctor.newInstance(value);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

