/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.tweak.StatementLocator;

public class ClasspathStatementLocator
implements StatementLocator {
    private static final String sep = "/";

    public static boolean looksLikeSql(String sql) {
        String local = sql.substring(0, 7).toLowerCase();
        return local.startsWith("insert ") || local.startsWith("update ") || local.startsWith("select ") || local.startsWith("call ") || local.startsWith("delete ") || local.startsWith("create ") || local.startsWith("alter ") || local.startsWith("drop ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String locate(String name, StatementContext ctx) {
        String filename;
        if (ClasspathStatementLocator.looksLikeSql(name)) {
            return name;
        }
        ClassLoader loader = ClasspathStatementLocator.selectClassLoader();
        InputStream in_stream = loader.getResourceAsStream(name);
        BufferedReader reader = null;
        if (in_stream == null) {
            in_stream = loader.getResourceAsStream(name + ".sql");
        }
        if (in_stream == null && ctx.getSqlObjectType() != null) {
            filename = '/' + ClasspathStatementLocator.mungify(ctx.getSqlObjectType().getName() + '.' + name) + ".sql";
            in_stream = this.getClass().getResourceAsStream(filename);
        }
        if (in_stream == null) {
            filename = name;
            return filename;
        }
        StringBuffer buffer = new StringBuffer();
        reader = new BufferedReader(new InputStreamReader(in_stream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (ClasspathStatementLocator.isComment(line)) continue;
                buffer.append(line).append(" ");
            }
        }
        catch (IOException e) {
            throw new UnableToCreateStatementException(e.getMessage(), e, ctx);
        }
        String string = buffer.toString();
        return string;
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static ClassLoader selectClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : ClasspathStatementLocator.class.getClassLoader();
        return loader;
    }

    private static boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("--") || line.startsWith("//");
    }

    private static String mungify(String path) {
        return path.replaceAll("\\.", Matcher.quoteReplacement(sep));
    }
}

