/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.worker.http;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.indexing.overlord.ForkingTaskRunner;
import java.io.InputStream;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/druid/worker/v1")
public class WorkerResource {
    private static final Logger log = new Logger(WorkerResource.class);
    private final ForkingTaskRunner taskRunner;

    @Inject
    public WorkerResource(ForkingTaskRunner taskRunner) throws Exception {
        this.taskRunner = taskRunner;
    }

    @POST
    @Path(value="/task/{taskid}/shutdown")
    @Produces(value={"application/json"})
    public Response doShutdown(@PathParam(value="taskid") String taskid) {
        try {
            this.taskRunner.shutdown(taskid);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Failed to issue shutdown for task: %s", new Object[]{taskid});
            return Response.serverError().build();
        }
        return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)taskid)).build();
    }

    @GET
    @Path(value="/task/{taskid}/log")
    @Produces(value={"text/plain"})
    public Response doGetLog(@PathParam(value="taskid") String taskid, @QueryParam(value="offset") @DefaultValue(value="0") long offset) {
        Optional<InputSupplier<InputStream>> stream = this.taskRunner.streamTaskLog(taskid, offset);
        if (stream.isPresent()) {
            try {
                return Response.ok((Object)((InputSupplier)stream.get()).getInput()).build();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Failed to read log for task: %s", new Object[]{taskid});
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

