/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.curator.announcement.Announcer;
import io.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import io.druid.indexing.worker.TaskAnnouncement;
import io.druid.indexing.worker.Worker;
import io.druid.server.initialization.ZkPathsConfig;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.joda.time.DateTime;

public class WorkerCuratorCoordinator {
    private static final Logger log = new Logger(WorkerCuratorCoordinator.class);
    private static final Joiner JOINER = Joiner.on((String)"/");
    private final Object lock = new Object();
    private final ObjectMapper jsonMapper;
    private final RemoteTaskRunnerConfig config;
    private final CuratorFramework curatorFramework;
    private final Worker worker;
    private final Announcer announcer;
    private final String baseAnnouncementsPath;
    private final String baseTaskPath;
    private final String baseStatusPath;
    private volatile boolean started;

    @Inject
    public WorkerCuratorCoordinator(ObjectMapper jsonMapper, ZkPathsConfig zkPaths, RemoteTaskRunnerConfig config, CuratorFramework curatorFramework, Worker worker) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.curatorFramework = curatorFramework;
        this.worker = worker;
        this.announcer = new Announcer(curatorFramework, (ExecutorService)MoreExecutors.sameThreadExecutor());
        this.baseAnnouncementsPath = this.getPath(Arrays.asList(zkPaths.getIndexerAnnouncementPath(), worker.getHost()));
        this.baseTaskPath = this.getPath(Arrays.asList(zkPaths.getIndexerTaskPath(), worker.getHost()));
        this.baseStatusPath = this.getPath(Arrays.asList(zkPaths.getIndexerStatusPath(), worker.getHost()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        log.info("WorkerCuratorCoordinator good to go sir. Server[%s]", new Object[]{this.worker.getHost()});
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.makePathIfNotExisting(this.getTaskPathForWorker(), CreateMode.PERSISTENT, ImmutableMap.of((Object)"created", (Object)new DateTime().toString()));
            this.makePathIfNotExisting(this.getStatusPathForWorker(), CreateMode.PERSISTENT, ImmutableMap.of((Object)"created", (Object)new DateTime().toString()));
            this.announcer.start();
            this.announcer.announce(this.getAnnouncementsPathForWorker(), this.jsonMapper.writeValueAsBytes((Object)this.worker));
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws Exception {
        log.info("Stopping WorkerCuratorCoordinator for worker[%s]", new Object[]{this.worker.getHost()});
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.announcer.unannounce(this.getAnnouncementsPathForWorker());
            this.announcer.stop();
            this.started = false;
        }
    }

    public void makePathIfNotExisting(String path, CreateMode mode, Object data) throws Exception {
        if (this.curatorFramework.checkExists().forPath(path) == null) {
            try {
                byte[] rawBytes = this.jsonMapper.writeValueAsBytes(data);
                if ((long)rawBytes.length > this.config.getMaxZnodeBytes()) {
                    throw new ISE("Length of raw bytes for task too large[%,d > %,d]", new Object[]{rawBytes.length, this.config.getMaxZnodeBytes()});
                }
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().creatingParentsIfNeeded().withMode(mode)).forPath(path, rawBytes);
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Could not create path[%s], perhaps it already exists?", new Object[]{path});
            }
        }
    }

    public String getPath(Iterable<String> parts) {
        return JOINER.join(parts);
    }

    public String getAnnouncementsPathForWorker() {
        return this.baseAnnouncementsPath;
    }

    public String getTaskPathForWorker() {
        return this.baseTaskPath;
    }

    public String getTaskPathForId(String taskId) {
        return this.getPath(Arrays.asList(this.baseTaskPath, taskId));
    }

    public String getStatusPathForWorker() {
        return this.baseStatusPath;
    }

    public String getStatusPathForId(String statusId) {
        return this.getPath(Arrays.asList(this.baseStatusPath, statusId));
    }

    public void unannounceTask(String taskId) {
        try {
            this.curatorFramework.delete().guaranteed().forPath(this.getTaskPathForId(taskId));
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Could not delete task path for task[%s]", new Object[]{taskId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announceTastAnnouncement(TaskAnnouncement announcement) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            try {
                byte[] rawBytes = this.jsonMapper.writeValueAsBytes((Object)announcement);
                if ((long)rawBytes.length > this.config.getMaxZnodeBytes()) {
                    throw new ISE("Length of raw bytes for task too large[%,d > %,d]", new Object[]{rawBytes.length, this.config.getMaxZnodeBytes()});
                }
                ((ACLBackgroundPathAndBytesable)this.curatorFramework.create().withMode(CreateMode.EPHEMERAL)).forPath(this.getStatusPathForId(announcement.getTaskStatus().getId()), rawBytes);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnnouncement(TaskAnnouncement announcement) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            try {
                if (this.curatorFramework.checkExists().forPath(this.getStatusPathForId(announcement.getTaskStatus().getId())) == null) {
                    this.announceTastAnnouncement(announcement);
                    return;
                }
                byte[] rawBytes = this.jsonMapper.writeValueAsBytes((Object)announcement);
                if ((long)rawBytes.length > this.config.getMaxZnodeBytes()) {
                    throw new ISE("Length of raw bytes for task too large[%,d > %,d]", new Object[]{rawBytes.length, this.config.getMaxZnodeBytes()});
                }
                this.curatorFramework.setData().forPath(this.getStatusPathForId(announcement.getTaskStatus().getId()), rawBytes);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

