/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.scaling;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.metamx.emitter.EmittingLogger;
import io.druid.guice.annotations.Json;
import io.druid.indexing.overlord.scaling.AutoScalingData;
import io.druid.indexing.overlord.scaling.AutoScalingStrategy;
import io.druid.indexing.overlord.scaling.SimpleResourceManagementConfig;
import io.druid.indexing.overlord.setup.EC2NodeData;
import io.druid.indexing.overlord.setup.GalaxyUserData;
import io.druid.indexing.overlord.setup.WorkerSetupData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class EC2AutoScalingStrategy
implements AutoScalingStrategy {
    private static final EmittingLogger log = new EmittingLogger(EC2AutoScalingStrategy.class);
    private final ObjectMapper jsonMapper;
    private final AmazonEC2 amazonEC2Client;
    private final SimpleResourceManagementConfig config;
    private final Supplier<WorkerSetupData> workerSetupDataRef;

    @Inject
    public EC2AutoScalingStrategy(@Json ObjectMapper jsonMapper, AmazonEC2 amazonEC2Client, SimpleResourceManagementConfig config, Supplier<WorkerSetupData> workerSetupDataRef) {
        this.jsonMapper = jsonMapper;
        this.amazonEC2Client = amazonEC2Client;
        this.config = config;
        this.workerSetupDataRef = workerSetupDataRef;
    }

    @Override
    public AutoScalingData provision() {
        try {
            WorkerSetupData setupData = (WorkerSetupData)this.workerSetupDataRef.get();
            EC2NodeData workerConfig = setupData.getNodeData();
            GalaxyUserData userData = setupData.getUserData();
            if (this.config.getWorkerVersion() != null) {
                userData = userData.withVersion(this.config.getWorkerVersion());
            }
            RunInstancesResult result = this.amazonEC2Client.runInstances(new RunInstancesRequest(workerConfig.getAmiId(), Integer.valueOf(workerConfig.getMinInstances()), Integer.valueOf(workerConfig.getMaxInstances())).withInstanceType(workerConfig.getInstanceType()).withSecurityGroupIds(workerConfig.getSecurityGroupIds()).withPlacement(new Placement(setupData.getAvailabilityZone())).withKeyName(workerConfig.getKeyName()).withUserData(Base64.encodeBase64String((byte[])this.jsonMapper.writeValueAsBytes((Object)userData))));
            List instanceIds = Lists.transform((List)result.getReservation().getInstances(), (Function)new Function<Instance, String>(){

                public String apply(Instance input) {
                    return input.getInstanceId();
                }
            });
            log.info("Created instances: %s", new Object[]{instanceIds});
            return new AutoScalingData(Lists.transform((List)result.getReservation().getInstances(), (Function)new Function<Instance, String>(){

                public String apply(Instance input) {
                    return input.getInstanceId();
                }
            }));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to provision any EC2 instances.", new Object[0]);
            return null;
        }
    }

    @Override
    public AutoScalingData terminate(List<String> ips) {
        if (ips.isEmpty()) {
            return new AutoScalingData(Lists.newArrayList());
        }
        DescribeInstancesResult result = this.amazonEC2Client.describeInstances(new DescribeInstancesRequest().withFilters(new Filter[]{new Filter("private-ip-address", ips)}));
        ArrayList instances = Lists.newArrayList();
        for (Reservation reservation : result.getReservations()) {
            instances.addAll(reservation.getInstances());
        }
        try {
            return this.terminateWithIds(Lists.transform((List)instances, (Function)new Function<Instance, String>(){

                public String apply(Instance input) {
                    return input.getInstanceId();
                }
            }));
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to terminate any instances.", new Object[0]);
            return null;
        }
    }

    @Override
    public AutoScalingData terminateWithIds(List<String> ids) {
        if (ids.isEmpty()) {
            return new AutoScalingData(Lists.newArrayList());
        }
        try {
            log.info("Terminating instances[%s]", new Object[]{ids});
            this.amazonEC2Client.terminateInstances(new TerminateInstancesRequest(ids));
            return new AutoScalingData(ids);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to terminate any instances.", new Object[0]);
            return null;
        }
    }

    @Override
    public List<String> ipToIdLookup(List<String> ips) {
        DescribeInstancesResult result = this.amazonEC2Client.describeInstances(new DescribeInstancesRequest().withFilters(new Filter[]{new Filter("private-ip-address", ips)}));
        ArrayList instances = Lists.newArrayList();
        for (Reservation reservation : result.getReservations()) {
            instances.addAll(reservation.getInstances());
        }
        List retVal = Lists.transform((List)instances, (Function)new Function<Instance, String>(){

            public String apply(Instance input) {
                return input.getInstanceId();
            }
        });
        log.debug("Performing lookup: %s --> %s", new Object[]{ips, retVal});
        return retVal;
    }

    @Override
    public List<String> idToIpLookup(List<String> nodeIds) {
        DescribeInstancesResult result = this.amazonEC2Client.describeInstances(new DescribeInstancesRequest().withFilters(new Filter[]{new Filter("instance-id", nodeIds)}));
        ArrayList instances = Lists.newArrayList();
        for (Reservation reservation : result.getReservations()) {
            instances.addAll(reservation.getInstances());
        }
        List retVal = Lists.transform((List)instances, (Function)new Function<Instance, String>(){

            public String apply(Instance input) {
                return input.getPrivateIpAddress();
            }
        });
        log.debug("Performing lookup: %s --> %s", new Object[]{nodeIds, retVal});
        return retVal;
    }
}

