/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.http;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.InputSupplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.common.config.JacksonConfigManager;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.actions.TaskActionHolder;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskExistsException;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.TaskQueue;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.TaskStorageQueryAdapter;
import io.druid.indexing.overlord.scaling.ResourceManagementScheduler;
import io.druid.indexing.overlord.setup.WorkerSetupData;
import io.druid.tasklogs.TaskLogStreamer;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;

@Path(value="/druid/indexer/v1")
public class OverlordResource {
    private static final Logger log = new Logger(OverlordResource.class);
    private final TaskMaster taskMaster;
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;
    private final TaskLogStreamer taskLogStreamer;
    private final JacksonConfigManager configManager;
    private AtomicReference<WorkerSetupData> workerSetupDataRef = null;

    @Inject
    public OverlordResource(TaskMaster taskMaster, TaskStorageQueryAdapter taskStorageQueryAdapter, TaskLogStreamer taskLogStreamer, JacksonConfigManager configManager) throws Exception {
        this.taskMaster = taskMaster;
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
        this.taskLogStreamer = taskLogStreamer;
        this.configManager = configManager;
    }

    @POST
    @Path(value="/merge")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response doMerge(Task task) {
        return this.doIndex(task);
    }

    @POST
    @Path(value="/index")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response doIndex(Task task) {
        return this.taskPost(task);
    }

    @POST
    @Path(value="/task")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response taskPost(final Task task) {
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                try {
                    taskQueue.add(task);
                    return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)task.getId())).build();
                }
                catch (TaskExistsException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)String.format("Task[%s] already exists!", task.getId()))).build();
                }
            }
        });
    }

    @GET
    @Path(value="/task/{taskid}")
    @Produces(value={"application/json"})
    public Response getTaskPayload(@PathParam(value="taskid") String taskid) {
        return this.optionalTaskResponse(taskid, "payload", this.taskStorageQueryAdapter.getTask(taskid));
    }

    @GET
    @Path(value="/task/{taskid}/status")
    @Produces(value={"application/json"})
    public Response getTaskStatus(@PathParam(value="taskid") String taskid) {
        return this.optionalTaskResponse(taskid, "status", this.taskStorageQueryAdapter.getStatus(taskid));
    }

    @GET
    @Path(value="/task/{taskid}/segments")
    @Produces(value={"application/json"})
    public Response getTaskSegments(@PathParam(value="taskid") String taskid) {
        Set<DataSegment> segments = this.taskStorageQueryAdapter.getInsertedSegments(taskid);
        return Response.ok().entity(segments).build();
    }

    @POST
    @Path(value="/task/{taskid}/shutdown")
    @Produces(value={"application/json"})
    public Response doShutdown(final @PathParam(value="taskid") String taskid) {
        return this.asLeaderWith(this.taskMaster.getTaskQueue(), new Function<TaskQueue, Response>(){

            public Response apply(TaskQueue taskQueue) {
                taskQueue.shutdown(taskid);
                return Response.ok((Object)ImmutableMap.of((Object)"task", (Object)taskid)).build();
            }
        });
    }

    @GET
    @Path(value="/worker/setup")
    @Produces(value={"application/json"})
    public Response getWorkerSetupData() {
        if (this.workerSetupDataRef == null) {
            this.workerSetupDataRef = this.configManager.watch("worker.setup", WorkerSetupData.class);
        }
        return Response.ok((Object)this.workerSetupDataRef.get()).build();
    }

    @POST
    @Path(value="/worker/setup")
    @Consumes(value={"application/json"})
    public Response setWorkerSetupData(WorkerSetupData workerSetupData) {
        if (!this.configManager.set("worker.setup", (Object)workerSetupData)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        log.info("Updating Worker Setup configs: %s", new Object[]{workerSetupData});
        return Response.ok().build();
    }

    @POST
    @Path(value="/action")
    @Produces(value={"application/json"})
    public <T> Response doAction(final TaskActionHolder<T> holder) {
        return this.asLeaderWith(this.taskMaster.getTaskActionClient(holder.getTask()), new Function<TaskActionClient, Response>(){

            public Response apply(TaskActionClient taskActionClient) {
                HashMap retMap;
                try {
                    Object ret = taskActionClient.submit(holder.getAction());
                    retMap = Maps.newHashMap();
                    retMap.put("result", ret);
                }
                catch (IOException e) {
                    log.warn((Throwable)e, "Failed to perform task action", new Object[0]);
                    return Response.serverError().build();
                }
                return Response.ok().entity((Object)retMap).build();
            }
        });
    }

    @GET
    @Path(value="/waitingTasks")
    @Produces(value={"application/json"})
    public Response getWaitingTasks() {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                List<Task> activeTasks = OverlordResource.this.taskStorageQueryAdapter.getActiveTasks();
                HashSet runnersKnownTasks = Sets.newHashSet((Iterable)Iterables.transform(taskRunner.getKnownTasks(), (Function)new Function<TaskRunnerWorkItem, String>(){

                    public String apply(TaskRunnerWorkItem workItem) {
                        return workItem.getTaskId();
                    }
                }));
                ArrayList waitingTasks = Lists.newArrayList();
                for (Task task : activeTasks) {
                    if (runnersKnownTasks.contains(task.getId())) continue;
                    waitingTasks.add(new TaskRunnerWorkItem(task.getId(), (ListenableFuture<TaskStatus>)SettableFuture.create(), new DateTime(0L), new DateTime(0L)));
                }
                return waitingTasks;
            }
        });
    }

    @GET
    @Path(value="/pendingTasks")
    @Produces(value={"application/json"})
    public Response getPendingTasks() {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                return taskRunner.getPendingTasks();
            }
        });
    }

    @GET
    @Path(value="/runningTasks")
    @Produces(value={"application/json"})
    public Response getRunningTasks() {
        return this.workItemsResponse(new Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>>(){

            public Collection<? extends TaskRunnerWorkItem> apply(TaskRunner taskRunner) {
                return taskRunner.getRunningTasks();
            }
        });
    }

    @GET
    @Path(value="/completeTasks")
    @Produces(value={"application/json"})
    public Response getCompleteTasks() {
        List completeTasks = Lists.transform(this.taskStorageQueryAdapter.getRecentlyFinishedTaskStatuses(), (Function)new Function<TaskStatus, TaskResponseObject>(){

            public TaskResponseObject apply(TaskStatus taskStatus) {
                return new TaskResponseObject(taskStatus.getId(), new DateTime(0L), new DateTime(0L), Optional.of((Object)taskStatus));
            }
        });
        return Response.ok((Object)completeTasks).build();
    }

    @GET
    @Path(value="/workers")
    @Produces(value={"application/json"})
    public Response getWorkers() {
        return this.asLeaderWith(this.taskMaster.getTaskRunner(), new Function<TaskRunner, Response>(){

            public Response apply(TaskRunner taskRunner) {
                return Response.ok(taskRunner.getWorkers()).build();
            }
        });
    }

    @GET
    @Path(value="/scaling")
    @Produces(value={"application/json"})
    public Response getScalingState() {
        Optional<ResourceManagementScheduler> rms = this.taskMaster.getResourceManagementScheduler();
        if (rms.isPresent()) {
            return Response.ok((Object)((ResourceManagementScheduler)rms.get()).getStats()).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/task/{taskid}/log")
    @Produces(value={"text/plain"})
    public Response doGetLog(@PathParam(value="taskid") String taskid, @QueryParam(value="offset") @DefaultValue(value="0") long offset) {
        try {
            Optional stream = this.taskLogStreamer.streamTaskLog(taskid, offset);
            if (stream.isPresent()) {
                return Response.ok((Object)((InputSupplier)stream.get()).getInput()).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to stream log for task %s", new Object[]{taskid});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Response workItemsResponse(final Function<TaskRunner, Collection<? extends TaskRunnerWorkItem>> fn) {
        return this.asLeaderWith(this.taskMaster.getTaskRunner(), new Function<TaskRunner, Response>(){

            public Response apply(TaskRunner taskRunner) {
                return Response.ok((Object)Lists.transform((List)Lists.newArrayList((Iterable)((Iterable)fn.apply((Object)taskRunner))), (Function)new Function<TaskRunnerWorkItem, TaskResponseObject>(){

                    public TaskResponseObject apply(TaskRunnerWorkItem workItem) {
                        return new TaskResponseObject(workItem.getTaskId(), workItem.getCreatedTime(), workItem.getQueueInsertionTime(), Optional.absent());
                    }
                })).build();
            }
        });
    }

    private <T> Response optionalTaskResponse(String taskid, String objectType, Optional<T> x) {
        HashMap results = Maps.newHashMap();
        results.put("task", taskid);
        if (x.isPresent()) {
            results.put(objectType, x.get());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)results).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)results).build();
    }

    private <T> Response asLeaderWith(Optional<T> x, Function<T, Response> f) {
        if (x.isPresent()) {
            return (Response)f.apply(x.get());
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    private static class TaskResponseObject {
        private final String id;
        private final DateTime createdTime;
        private final DateTime queueInsertionTime;
        private final Optional<TaskStatus> status;

        private TaskResponseObject(String id, DateTime createdTime, DateTime queueInsertionTime, Optional<TaskStatus> status) {
            this.id = id;
            this.createdTime = createdTime;
            this.queueInsertionTime = queueInsertionTime;
            this.status = status;
        }

        public String getId() {
            return this.id;
        }

        public DateTime getCreatedTime() {
            return this.createdTime;
        }

        public DateTime getQueueInsertionTime() {
            return this.queueInsertionTime;
        }

        public Optional<TaskStatus> getStatus() {
            return this.status;
        }

        @JsonValue
        public Map<String, Object> toJson() {
            LinkedHashMap data = Maps.newLinkedHashMap();
            data.put("id", this.id);
            if (this.createdTime.getMillis() > 0L) {
                data.put("createdTime", this.createdTime);
            }
            if (this.queueInsertionTime.getMillis() > 0L) {
                data.put("queueInsertionTime", this.queueInsertionTime);
            }
            if (this.status.isPresent()) {
                data.put("statusCode", ((TaskStatus)this.status.get()).getStatusCode().toString());
            }
            return data;
        }
    }
}

