/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.emitter.EmittingLogger;
import io.druid.concurrent.Execs;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.TaskToolboxFactory;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.overlord.ZkWorker;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.SegmentDescriptor;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FileUtils;
import org.joda.time.Interval;

public class ThreadPoolTaskRunner
implements TaskRunner,
QuerySegmentWalker {
    private final TaskToolboxFactory toolboxFactory;
    private final ListeningExecutorService exec;
    private final Set<ThreadPoolTaskRunnerWorkItem> runningItems = new ConcurrentSkipListSet<ThreadPoolTaskRunnerWorkItem>();
    private static final EmittingLogger log = new EmittingLogger(ThreadPoolTaskRunner.class);

    @Inject
    public ThreadPoolTaskRunner(TaskToolboxFactory toolboxFactory) {
        this.toolboxFactory = (TaskToolboxFactory)Preconditions.checkNotNull((Object)toolboxFactory, (Object)"toolboxFactory");
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"task-runner-%d"));
    }

    @LifecycleStop
    public void stop() {
        this.exec.shutdownNow();
    }

    @Override
    public ListenableFuture<TaskStatus> run(Task task) {
        TaskToolbox toolbox = this.toolboxFactory.build(task);
        ListenableFuture statusFuture = this.exec.submit((Callable)new ThreadPoolTaskRunnerCallable(task, toolbox));
        final ThreadPoolTaskRunnerWorkItem taskRunnerWorkItem = new ThreadPoolTaskRunnerWorkItem(task, statusFuture);
        this.runningItems.add(taskRunnerWorkItem);
        Futures.addCallback((ListenableFuture)statusFuture, (FutureCallback)new FutureCallback<TaskStatus>(){

            public void onSuccess(TaskStatus result) {
                ThreadPoolTaskRunner.this.runningItems.remove(taskRunnerWorkItem);
            }

            public void onFailure(Throwable t) {
                ThreadPoolTaskRunner.this.runningItems.remove(taskRunnerWorkItem);
            }
        });
        return statusFuture;
    }

    @Override
    public void shutdown(String taskid) {
        for (TaskRunnerWorkItem taskRunnerWorkItem : this.runningItems) {
            if (!taskRunnerWorkItem.getTaskId().equals(taskid)) continue;
            taskRunnerWorkItem.getResult().cancel(true);
        }
    }

    public Collection<TaskRunnerWorkItem> getRunningTasks() {
        return ImmutableList.copyOf(this.runningItems);
    }

    public Collection<TaskRunnerWorkItem> getPendingTasks() {
        return ImmutableList.of();
    }

    public Collection<TaskRunnerWorkItem> getKnownTasks() {
        return ImmutableList.copyOf(this.runningItems);
    }

    @Override
    public Collection<ZkWorker> getWorkers() {
        return Lists.newArrayList();
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.getQueryRunnerImpl(query);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.getQueryRunnerImpl(query);
    }

    private <T> QueryRunner<T> getQueryRunnerImpl(Query<T> query) {
        QueryRunner<T> queryRunner = null;
        for (ThreadPoolTaskRunnerWorkItem taskRunnerWorkItem : ImmutableList.copyOf(this.runningItems)) {
            QueryRunner<T> taskQueryRunner;
            Task task = taskRunnerWorkItem.getTask();
            if (!task.getDataSource().equals(query.getDataSource()) || (taskQueryRunner = task.getQueryRunner(query)) == null) continue;
            if (queryRunner == null) {
                queryRunner = taskQueryRunner;
                continue;
            }
            log.makeAlert("Found too many query runners for datasource", new Object[0]).addData("dataSource", (Object)query.getDataSource()).emit();
        }
        return queryRunner == null ? new QueryRunner<T>() : queryRunner;
    }

    private static class ThreadPoolTaskRunnerCallable
    implements Callable<TaskStatus> {
        private final Task task;
        private final TaskToolbox toolbox;

        public ThreadPoolTaskRunnerCallable(Task task, TaskToolbox toolbox) {
            this.task = task;
            this.toolbox = toolbox;
        }

        @Override
        public TaskStatus call() {
            TaskStatus status;
            long startTime = System.currentTimeMillis();
            File taskDir = this.toolbox.getTaskWorkDir();
            try {
                log.info("Running task: %s", new Object[]{this.task.getId()});
                status = this.task.run(this.toolbox);
            }
            catch (InterruptedException e) {
                log.error((Throwable)e, "Interrupted while running task[%s]", new Object[]{this.task});
                throw Throwables.propagate((Throwable)e);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception while running task[%s]", new Object[]{this.task});
                status = TaskStatus.failure(this.task.getId());
            }
            catch (Throwable t) {
                log.error(t, "Uncaught Throwable while running task[%s]", new Object[]{this.task});
                throw Throwables.propagate((Throwable)t);
            }
            try {
                if (taskDir.exists()) {
                    log.info("Removing task directory: %s", new Object[]{taskDir});
                    FileUtils.deleteDirectory((File)taskDir);
                }
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Failed to delete task directory", new Object[0]).addData("taskDir", (Object)taskDir.toString()).addData("task", (Object)this.task.getId()).emit();
            }
            try {
                return status.withDuration(System.currentTimeMillis() - startTime);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Uncaught Exception during callback for task[%s]", new Object[]{this.task});
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static class ThreadPoolTaskRunnerWorkItem
    extends TaskRunnerWorkItem {
        private final Task task;

        private ThreadPoolTaskRunnerWorkItem(Task task, ListenableFuture<TaskStatus> result) {
            super(task.getId(), result);
            this.task = task;
        }

        public Task getTask() {
            return this.task;
        }
    }
}

